#include <bfin_sram.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

int main(int argc, char *argv[])
{
	void *l1_addr = (void *)0xf0000000;
	void *src_addr, *dst_addr;
	size_t count;
	enum { AUTO, DMA, CORE } use_dma = AUTO;

	if (argc > 1) {
		if (!strcmp(argv[1], "-d"))
			use_dma = DMA;
		else if (!strcmp(argv[1], "-c"))
			use_dma = CORE;
		if (use_dma != AUTO)
			--argc, ++argv;
	}

	if (argc != 3) {
		fprintf(stderr,
			"Usage: dump [-d|-c] <address> <count>\n"
			" -d - use DMA for copy (default if address >= %p)\n"
			" -c - use core loads (default if address < %p)\n"
			"Values are in hex.\n", l1_addr, l1_addr);
		return EXIT_FAILURE;
	}

	src_addr = (void *)strtoul(argv[1], NULL, 16);
	count = strtoul(argv[2], NULL, 16);
	if (use_dma == AUTO)
		use_dma = (src_addr >= l1_addr ? DMA : CORE);

	fprintf(stderr, "Copying %zi bytes from %p\n", count, src_addr);

	dst_addr = malloc(count);
	fprintf(stderr, "%smemcpy(%p, %p, %zi);\n",
		(use_dma == DMA ? "dma_" : ""),
		dst_addr, src_addr, count);
	if (use_dma == DMA)
		dma_memcpy(dst_addr, src_addr, count);
	else
		memcpy(dst_addr, src_addr, count);
	fprintf(stderr, "write(%i, %p, %zi);\n", 1, dst_addr, count);
	write(1, dst_addr, count);

	return 0;
}
