#define _GNU_SOURCE
#include <err.h>
#include <fcntl.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/ioctl.h>

#define LOOP_CTL_ADD        0x4C80
#define LOOP_CTL_REMOVE     0x4C81

static void usage(const char *prog)
{
	printf(
		"Usage: %s -a <loop num to add>\n"
		"Usage: %s -r <loop num to remove>\n",
		prog, prog
	);
	exit(0);
}

static int op(int cmd, const char *snum)
{
	static int fd = -1;
	int ret, num;

	num = atoi(snum);
	if (num < 0)
		err(1, "invalid number: %s", snum);

	if (fd == -1) {
		fd = open("/dev/loop-control", O_WRONLY|O_CLOEXEC);
		if (fd < 0)
			err(1, "cannot open /dev/loop-control");
	}

	ret = ioctl(fd, cmd, num);
	if (ret != num) {
		warn("could not update loop %i: %i", num, ret);
		return EXIT_FAILURE;
	} else
		return EXIT_SUCCESS;
}

int main(int argc, char *argv[])
{
	int c, ret = EXIT_SUCCESS;

	while ((c = getopt(argc, argv, "ha:r:")) != -1) {
		switch (c) {
		default:
			usage(argv[0]);
		case 'a':
			ret |= op(LOOP_CTL_ADD, optarg);
			break;
		case 'r':
			ret |= op(LOOP_CTL_REMOVE, optarg);
			break;
		}
	}

	return ret;
}
