/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.tools.debug.ui.internal.view;

import com.google.dart.tools.debug.ui.internal.view.DebuggerPatternMatchListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;

public class DebuggerPatternMatchListenerTest
extends TestCase {
    Pattern dartiumPattern1 = Pattern.compile(DebuggerPatternMatchListener.DARTIUM_PATTERN_1);
    Pattern dartiumPattern2 = Pattern.compile(DebuggerPatternMatchListener.DARTIUM_PATTERN_2);
    Pattern unitTestPattern = Pattern.compile(DebuggerPatternMatchListener.UNITTEST_PATTERN);

    public void testDartiumPattern1() {
        Matcher matcher = this.dartiumPattern1.matcher("(http://127.0.0.1:3030/Users/util/debuggertest/web_test.dart:33:14)");
        DebuggerPatternMatchListenerTest.assertEquals((boolean)true, (boolean)matcher.find());
        DebuggerPatternMatchListenerTest.assertEquals((String)"http://127.0.0.1:3030/Users/util/debuggertest/web_test.dart", (String)matcher.group(1));
        DebuggerPatternMatchListenerTest.assertEquals((String)"33", (String)matcher.group(2));
    }

    public void testDartiumPattern2() {
        Matcher matcher = this.dartiumPattern1.matcher("(file:///Users/devoncarew/projects/dart/dart/editor/util/debuggertest/cmd_test.dart:30:11)");
        DebuggerPatternMatchListenerTest.assertEquals((boolean)true, (boolean)matcher.find());
        DebuggerPatternMatchListenerTest.assertEquals((String)"file:///Users/devoncarew/projects/dart/dart/editor/util/debuggertest/cmd_test.dart", (String)matcher.group(1));
        DebuggerPatternMatchListenerTest.assertEquals((String)"30", (String)matcher.group(2));
    }

    public void testDartiumPattern3() {
        Matcher matcher = this.dartiumPattern2.matcher("(web.dart:10)");
        DebuggerPatternMatchListenerTest.assertEquals((boolean)true, (boolean)matcher.find());
        DebuggerPatternMatchListenerTest.assertEquals((String)"web.dart", (String)matcher.group(1));
        DebuggerPatternMatchListenerTest.assertEquals((String)"10", (String)matcher.group(2));
    }

    public void testUnitTestPattern1() {
        Matcher matcher = this.unitTestPattern.matcher("  cmd.dart 67:13                                        main.<fn>.<fn>");
        DebuggerPatternMatchListenerTest.assertEquals((boolean)true, (boolean)matcher.find());
        DebuggerPatternMatchListenerTest.assertEquals((String)"cmd.dart", (String)matcher.group(1));
        DebuggerPatternMatchListenerTest.assertEquals((String)"67", (String)matcher.group(2));
    }

    public void testUnitTestPattern2() {
        Matcher matcher = this.unitTestPattern.matcher("  package:unittest/src/test_case.dart 109:30            _run.<fn>");
        DebuggerPatternMatchListenerTest.assertEquals((boolean)true, (boolean)matcher.find());
        DebuggerPatternMatchListenerTest.assertEquals((String)"package:unittest/src/test_case.dart", (String)matcher.group(1));
        DebuggerPatternMatchListenerTest.assertEquals((String)"109", (String)matcher.group(2));
    }

    public void testUnitTestPattern3() {
        Matcher matcher = this.unitTestPattern.matcher("  dart:async/zone.dart 717                              _rootRunUnary");
        DebuggerPatternMatchListenerTest.assertEquals((boolean)true, (boolean)matcher.find());
        DebuggerPatternMatchListenerTest.assertEquals((String)"dart:async/zone.dart", (String)matcher.group(1));
        DebuggerPatternMatchListenerTest.assertEquals((String)"717", (String)matcher.group(2));
    }
}

