VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cStreamReader"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
Private Const MODULE = "UnZixWin.StreamReader"
'This class handles some of the drudgery in dealing with IStreams.
'Note that none of the methods are shielded by an error trap. This
'is so the assertion functions can kick us right out to the source
'of the method call.
Public Enum StreamReaderErrorEnum
    ERR_BASE_STR_ERR = 19000
    ERR_STREAM_NOT_OPEN = ERR_BASE_STR_ERR + 1
    ERR_NO_STREAM_OBJECT
    ERR_STREAM_IS_EMPTY
    ERR_NOT_ENOUGH_DATA
    ERR_OFFSET_TOO_LARGE
    ERR_INVALID_OFFSET
    ERR_INCOMPLETE_COPY
    ERR_INVALID_ARGUMENT
    ERR_TOO_MANY_POPS
End Enum

Private m_objStream As IStream
Private m_Stat As STATSTG
'Note! All these values are in ISteam LARGE_INTEGER format, stuffed
'into a currency variable. We have to multiply by 10000 to get an
'integral value.
Private m_StartPos As Currency 'Where the stream was at when we got it.
Private m_CurrPos As Currency  'Where we are now
Private m_TotalSize As Currency 'Total size of stream
Private m_cPushes As Long       'Count of position pushes
Private arrPushes() As Currency 'push stack
Private Sub fAssertAvailable(ByVal nBytes As Currency)
    'CHANGE: We now pass in the requested value in LARGE_INTEGER format.
    'No Division is thus necessary
    If m_objStream Is Nothing Then
        Err.Raise ERR_NO_STREAM_OBJECT, MODULE, "No stream has beend assigned or opened."
    End If
    'This checks that we can read how many bytes is
    'requested, or throw a big fat error otherwise.
    Dim currRequested As Currency
    'convert to stream format
    currRequested = nBytes / 10000
    If fGetPos + currRequested > m_TotalSize Then
        Err.Raise ERR_NOT_ENOUGH_DATA, "cStreamReader", "Attempted to read past end of file."
    End If
End Sub
Private Sub fCheckStats()
    m_objStream.Stat m_Stat, STATFLAG_NONAME
    m_TotalSize = m_Stat.cbSize
    m_CurrPos = fGetPos
End Sub
Private Function fGetPos() As Currency
    'Seeking 0 bytes past current position returns
    'current position as last position
    fGetPos = m_objStream.Seek(0, STREAM_SEEK_CUR)
End Function
Public Property Get Stream() As IStream
    Set Stream = m_objStream
End Property
Public Sub CreateOnStream(ByVal RHS As IStream, Optional ByVal StartAt As STREAM_SEEK = STREAM_SEEK_CUR)
    Set m_objStream = RHS
    fCheckStats
    m_StartPos = m_CurrPos
End Sub
Public Sub CreateOnFile(ByVal strFileName As String)
    Dim lret As Long
    'We open the stream for read-only, exclusive mode, so that nobody, not even
    'us, can mess with the file while we're operating on it.
    Set m_objStream = SHCreateStreamOnFile(strFileName, STGM_READ Or STGM_SHARE_EXCLUSIVE)
    'Set m_objStream = SHCreateStreamOnFile(strFileName, STGM_READ)
    Call fCheckStats
    m_StartPos = m_CurrPos
    
End Sub
Public Sub Push()
    m_cPushes = m_cPushes + 1
    If UBound(arrPushes) < m_cPushes Then
        'Reserve space in chunks of 10
        ReDim Preserve arrPushes(m_cPushes + 10)
    End If
    'And store our curren read position
    arrPushes(m_cPushes) = fGetPos
End Sub
Public Sub Pop()
    If m_cPushes > 0 Then
        m_CurrPos = m_objStream.Seek(arrPushes(m_cPushes), STREAM_SEEK_SET)
        'm_CurrPos = fGetPos
        m_cPushes = m_cPushes - 1
    Else
        Err.Raise ERR_TOO_MANY_POPS, MODULE, "Attempt to Pop() from an empty Push stack."
    End If
End Sub
Public Function ReadChar() As String
    Dim posAfter As Currency
    posAfter = m_CurrPos + 0.0001
    If posAfter > m_TotalSize Then
        Err.Raise ERR_NOT_ENOUGH_DATA, "cStreamReader::ReadChar", "Attempted to read past end of file."
    End If
    'Call fAssertAvailable(1)
    Dim c As Byte
    m_objStream.Read c, 1
    ReadChar = Chr$(c)
    m_CurrPos = posAfter
End Function
'This function reads ANSI (one byte per character) data and returns
'as a string
Public Function ReadCharsA(ByVal nChars As Long) As String
    Dim posAfter As Currency
    posAfter = m_CurrPos + (nChars / 10000)
    If posAfter > m_TotalSize Then
        Err.Raise ERR_NOT_ENOUGH_DATA, "cStreamReader::ReadCharsA", "Attempted to read past end of file."
    End If
    Dim arrChars() As Byte
    'Allocate byte array space
    ReDim arrChars(0 To nChars - 1)
    'read into byte array
    m_objStream.Read arrChars(0), nChars
    'and convert to string
    ReadCharsA = StrConv(arrChars, vbUnicode)
    m_CurrPos = posAfter
End Function
'This funciton reads Unicode data (2 bytes per character) and
'returns as a string. Note that we stream the data directly
'into string memory.
Public Function ReadCharsW(ByVal nChars As Long) As String
    Dim posAfter As Currency
    posAfter = m_CurrPos + ((2 * nChars) / 10000)
    If posAfter > m_TotalSize Then
        Err.Raise ERR_NOT_ENOUGH_DATA, "cStreamReader::ReadCharsW", "Attempted to read past end of file."
    End If
    'Allocate string space in return string
    ReadCharsW = String$(nChars, vbNullChar)
    'And read directly into string memory
    m_objStream.Read ByVal StrPtr(ReadCharsW), nChars * 2
    m_CurrPos = posAfter
End Function
Public Function ReadLong() As Long
    Dim posAfter As Currency
    posAfter = m_CurrPos + 0.0004
    If posAfter > m_TotalSize Then
        Err.Raise ERR_NOT_ENOUGH_DATA, "cStreamReader::ReadLong", "Attempted to read past end of file."
    End If
    m_objStream.Read ReadLong, 4
    m_CurrPos = posAfter
End Function
Public Function ReadLongLong() As Currency
    Dim posAfter As Currency
    posAfter = m_CurrPos + 0.0008
    If posAfter > m_TotalSize Then
        Err.Raise ERR_NOT_ENOUGH_DATA, "cStreamReader", "Attempted to read past end of file."
    End If
    'Read 8 bytes directly into the memory reserved
    'for the return value.
    m_objStream.Read ReadLongLong, 8
    'And shift it left to make it integral
    ReadLongLong = ReadLongLong * 10000
    m_CurrPos = posAfter
End Function
Public Sub SeekPos(ByVal nBytes As Currency, ByVal SeekMode As STREAM_SEEK)
    Dim posAfter As Currency
    'Compute where we would be after the seek
    Select Case SeekMode
        Case STREAM_SEEK_SET 'absolute address.
            posAfter = nBytes / 10000
        Case STREAM_SEEK_CUR
            posAfter = m_CurrPos + (nBytes / 10000)
        Case STREAM_SEEK_END
            posAfter = (m_TotalSize - 0.0001) - (nBytes / 10000)
        Case Else
            Err.Raise ERR_INVALID_ARGUMENT, "cStreamReader", "Seek mode must be in the range 0-2."
    End Select
    If posAfter > m_TotalSize Then
        Err.Raise ERR_NOT_ENOUGH_DATA, "cStreamReader::SeekPos", "Attempted to read past end of file."
    ElseIf posAfter < 0 Then
        Err.Raise ERR_INVALID_OFFSET, "cStreamReader::SeekPos", "Attempt to seek past beginning of file."
    End If
    'Having already computed the absolute address, let's do
    'absolute seeking to get there fast.
    m_CurrPos = m_objStream.Seek(posAfter, STREAM_SEEK_SET)
End Sub


Public Sub Read(ByRef pDest As Byte, ByVal nBytes As Currency)
    Dim posAfter As Currency
    posAfter = m_CurrPos + (nBytes / 10000)
    If posAfter > m_TotalSize Then
        Err.Raise ERR_NOT_ENOUGH_DATA, "cStreamReader", "Attempted to read past end of file."
    End If
    'Dangerous. This assumes we pass the first element of
    'a byte array, and that that byte array is predimensioned
    'to hold that many bytes. Otherwise... kaboom!
    m_objStream.Read pDest, nBytes
    m_CurrPos = posAfter
End Sub
Public Sub CopyToStream(ByVal outStr As IStream, ByVal nBytes As Currency)
    Dim posAfter As Currency
    posAfter = m_CurrPos + (nBytes / 10000)
    If posAfter > m_TotalSize Then
        Err.Raise ERR_NOT_ENOUGH_DATA, "cStreamReader", "Attempted to read past end of file."
    End If
    Dim nRead As Currency, nWritten As Currency
    Call fAssertAvailable(nBytes)
    m_objStream.CopyTo outStr, nBytes / 10000, nRead, nWritten
    m_CurrPos = posAfter
End Sub
Public Function EOF() As Boolean
    If fGetPos >= m_TotalSize Then
        EOF = True
    End If
End Function
Public Function Pos() As Currency
    Pos = fGetPos * 10000
End Function
Public Function TotalSize() As Currency
    TotalSize = m_TotalSize * 10000
End Function
Private Sub Class_Initialize()
    'Initialize array
    ReDim arrPushes(0)
End Sub
