VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cStreamReader"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
Private Const MODULE = "UnZixWin.StreamReader"
'This class handles some of the drudgery in dealing with IStreams.
'Note that none of the methods are shielded by an error trap. This
'is so the assertion functions can kick us right out to the source
'of the method call.
Public Enum StreamReaderErrorEnum
    ERR_BASE_STR_ERR = 19000
    ERR_STREAM_NOT_OPEN = ERR_BASE_STR_ERR + 1
    ERR_NO_STREAM_OBJECT
    ERR_STREAM_IS_EMPTY
    ERR_NOT_ENOUGH_DATA
    ERR_OFFSET_TOO_LARGE
    ERR_INVALID_OFFSET
    ERR_INCOMPLETE_COPY
    ERR_INVALID_ARGUMENT
    ERR_TOO_MANY_POPS
End Enum

Private m_objStream As IStream
Private m_Stat As STATSTG
Private m_StartPos As Currency
Private m_CurrPos As Currency
Private m_TotalSize As Currency
Private m_cPushes As Long
Private arrPushes() As Currency
Private Sub fAssertAvailable(ByVal nBytes As Currency)
    If m_objStream Is Nothing Then
        Err.Raise ERR_NO_STREAM_OBJECT, MODULE, "No stream has beend assigned or opened."
    End If
    'This checks that we can read how many bytes is
    'requested, or throw a big fat error otherwise.
    Dim currRequested As Currency
    'convert to stream format
    currRequested = nBytes / 10000
    If fGetPos + currRequested > m_TotalSize Then
        Err.Raise ERR_NOT_ENOUGH_DATA, "cStreamReader", "Attempted to read past end of file."
    End If
End Sub
Private Sub fCheckStats()
    m_objStream.Stat m_Stat, STATFLAG_NONAME
    m_TotalSize = m_Stat.cbSize
    m_CurrPos = fGetPos
End Sub
Private Function fGetPos() As Currency
    'Seeking 0 bytes past current position returns
    'current position as last position
    fGetPos = m_objStream.Seek(0, STREAM_SEEK_CUR)
End Function
Public Property Set Stream(ByVal str As IStream)
    Set m_objStream = str
    m_StartPos = fGetPos
    fCheckStats
End Property
Public Sub CreateOnStream(ByVal RHS As IStream, Optional ByVal StartAt As STREAM_SEEK = STREAM_SEEK_CUR)
    Set m_objStream = RHS
    fCheckStats
End Sub
Public Sub CreateOnFile(ByVal strFileName As String)
    Dim lret As Long
    'We open the stream for read-only, exclusive mode, so that nobody, not even
    'us, can mess with the file while we're operating on it.
    'Set m_objStream = SHCreateStreamOnFile(strFileName, STGM_READ Or STGM_SHARE_EXCLUSIVE)
    Set m_objStream = SHCreateStreamOnFile(strFileName, STGM_READ)
    m_StartPos = fGetPos
    Call fCheckStats
End Sub
Public Sub Push()
    m_cPushes = m_cPushes + 1
    If UBound(arrPushes) < m_cPushes Then
        'Reserve space in chunks of 10
        ReDim Preserve arrPushes(m_cPushes + 10)
    End If
    'And store our curren read position
    arrPushes(m_cPushes) = fGetPos
End Sub
Public Sub Pop()
    If m_cPushes > 0 Then
        m_objStream.Seek arrPushes(m_cPushes), STREAM_SEEK_SET
        m_CurrPos = fGetPos
        m_cPushes = m_cPushes - 1
    Else
        Err.Raise ERR_TOO_MANY_POPS, MODULE, "Attempt to Pop() from an empty Push stack."
    End If
End Sub
Public Function ReadChar() As String
    Call fAssertAvailable(1)
    Dim c As Byte
    m_objStream.Read c, 1
    ReadChar = Chr$(c)
End Function
'This function reads ANSI (one byte per character) data and returns
'as a string
Public Function ReadCharsA(ByVal nChars As Long) As String
    Call fAssertAvailable(nChars)
    Dim arrChars() As Byte
    'Allocate byte array space
    ReDim arrChars(0 To nChars - 1)
    'read into byte array
    m_objStream.Read arrChars(0), nChars
    'and convert to string
    ReadCharsA = StrConv(arrChars, vbUnicode)
End Function
'This funciton reads Unicode data (2 bytes per character) and
'returns as a string. Note that we stream the data directly
'into string memory.
Public Function ReadCharsW(ByVal nChars As Long) As String
    Call fAssertAvailable(nChars * 2)
    'Allocate string space in return string
    ReadCharsW = String$(nChars, vbNullChar)
    'And read directly into string memory
    m_objStream.Read ByVal StrPtr(ReadCharsW), nChars * 2
End Function
Public Function ReadLong() As Long
    Call fAssertAvailable(4)
    m_objStream.Read ReadLong, 4
End Function
Public Function ReadLongLong() As Currency
    Call fAssertAvailable(8)
    'Read 8 bytes directly into the memory reserved
    'for the return value.
    m_objStream.Read ReadLongLong, 8
    'And shift it left to make it integral
    ReadLongLong = ReadLongLong * 10000
End Function
Public Sub SeekPos(ByVal nBytes As Currency, ByVal SeekMode As STREAM_SEEK)
    Dim currOffset As Currency
    currOffset = nBytes / 10000
    Select Case SeekMode
        Case STREAM_SEEK_SET
            If m_TotalSize > currOffset Then
                m_CurrPos = m_objStream.Seek((currOffset), STREAM_SEEK_SET)
            Else
                Err.Raise ERR_OFFSET_TOO_LARGE, "cStreamReader", "Attempt to seek past end of file."
            End If
        Case STREAM_SEEK_CUR
            Call fAssertAvailable(nBytes)
            m_CurrPos = m_objStream.Seek(currOffset, STREAM_SEEK_CUR)
        Case STREAM_SEEK_END
            If currOffset > m_TotalSize Then
                Err.Raise ERR_INVALID_OFFSET, "cStreamReader", "Attempt to seek past beginning of file."
            End If
            m_CurrPos = m_objStream.Seek(currOffset, STREAM_SEEK_END)
        Case Else
            Err.Raise ERR_INVALID_ARGUMENT, "cStreamReader", "Seek mode must be in the range 0-2."
    End Select
End Sub


Public Sub Read(ByRef pDest As Byte, ByVal nBytes As Currency)
    Call fAssertAvailable(nBytes)
    'Dangerous. This assumes we pass the first element of
    'a byte array, and that that byte array is predimensioned
    'to hold that many bytes. Otherwise... kaboom!
    m_objStream.Read pDest, nBytes
End Sub
Public Sub CopyToStream(ByVal outStr As IStream, ByVal nBytes As Currency)
    Dim nRead As Currency, nWritten As Currency
    Call fAssertAvailable(nBytes)
    m_objStream.CopyTo outStr, nBytes / 10000, nRead, nWritten
End Sub
Public Function EOF() As Boolean
    If fGetPos >= m_TotalSize Then
        EOF = True
    End If
End Function
Public Function Pos() As Currency
    Pos = fGetPos * 10000
End Function
Public Function TotalSize() As Currency
    TotalSize = m_TotalSize * 10000
End Function
Private Sub Class_Initialize()
    'Initialize array
    ReDim arrPushes(0)
End Sub
