VERSION 5.00
Begin VB.Form frmCopyProgress 
   BorderStyle     =   3  'Fixed Dialog
   ClientHeight    =   1995
   ClientLeft      =   45
   ClientTop       =   45
   ClientWidth     =   4680
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   133
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   312
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   285
      Left            =   1785
      TabIndex        =   4
      Top             =   1560
      Width           =   915
   End
   Begin VB.Label lblFileName 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Label2"
      Height          =   570
      Left            =   195
      TabIndex        =   3
      Top             =   495
      UseMnemonic     =   0   'False
      Width           =   4290
      WordWrap        =   -1  'True
   End
   Begin VB.Label lblLegend 
      Caption         =   "Extracting"
      Height          =   210
      Left            =   1980
      TabIndex        =   2
      Top             =   120
      Width           =   780
   End
   Begin VB.Label lblCell 
      BackColor       =   &H0000FF00&
      Height          =   180
      Index           =   0
      Left            =   555
      TabIndex        =   1
      Top             =   900
      Width           =   135
   End
   Begin VB.Label lblProgBar 
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   495
      TabIndex        =   0
      Top             =   1215
      Width           =   3735
   End
End
Attribute VB_Name = "frmCopyProgress"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'This form is a fun little experiment in implementing special effects
'without common controls or APIs. Just for giggles.
'A ProgressBar is implemented using a few labels and a bit of fiddling.
Private m_lngCellCount As Long
Private m_bCanceled As Boolean
Private WithEvents oBFC As cBinFileCopy
Attribute oBFC.VB_VarHelpID = -1

Friend Property Let CopyObject(objBFC As cBinFileCopy)
    Set oBFC = objBFC
    lblFileName.Caption = objBFC.DestinationFile
End Property

Private Sub cmdCancel_Click()
    m_bCanceled = True
End Sub

Private Sub Form_Activate()
    Center Me
End Sub

Private Sub Form_Initialize()
    m_lngCellCount = 40
End Sub

Private Sub Form_Load()
    ScaleMode = 3
    Dim I As Integer
    'Initially, we hide all the cells
    lblCell(0).Visible = 0
    'We instantiate as many cells as needed to fill our progressbar
    For I = 1 To m_lngCellCount - 1
        Load lblCell(I)
        lblCell(I).Visible = False
    Next I
End Sub

Private Sub Form_Resize()
    Dim lngWidth As Long, lngLeft As Long, lngHeight As Long, lngTop As Long
    Dim I As Long
    'Center stuff
    lblProgBar.Move 30, lblProgBar.Top, ScaleWidth - 60, 17
    'Now compute the size of a single cell. We account for the
    'dimensions of the cell border and some whitespace
    lngWidth = ((lblProgBar.Width - 4) - (m_lngCellCount + 1)) / m_lngCellCount
    lngHeight = lblProgBar.Height - 6 'two-pixel border and 1-pixel whitespace on each size
    lngTop = lblProgBar.Top + 3
    lngLeft = lblProgBar.Left + 3
    'That done, we reposition each cell. Never mind which are visible.
    For I = 0 To m_lngCellCount - 1
        lblCell(I).Move lngLeft, lngTop, lngWidth, lngHeight
        lblCell(I).ZOrder 0
        'and advance the left position
        lngLeft = lngLeft + lngWidth + 1
    Next I
End Sub

Private Sub oBFC_Done()
    Set oBFC = Nothing
    Unload Me
End Sub

Private Sub oBFC_ProgressChange(ByVal Min As Long, ByVal Max As Long, ByVal Current As Long, Cancel As Boolean)
    Dim dblPct As Double
    dblPct = Current / Max
    Call UpdateProgress(dblPct)
    DoEvents
    Cancel = m_bCanceled
End Sub
Private Sub UpdateProgress(ByVal dblPercent As Double)
    'We now show as many cells as correspond to this percentage
    Dim lngCells As Long
    Dim I As Long
    lngCells = CLng(dblPercent * m_lngCellCount)
    If lngCells Then
        For I = 0 To lngCells - 1
            lblCell(I).Visible = True
            lblCell(I).ZOrder 0
        Next
    End If
End Sub

Private Sub oBFC_UserCanceled()
    Set oBFC = Nothing
    Unload Me
End Sub
