VERSION 5.00
Begin VB.Form frmStreamCopyProgress 
   BorderStyle     =   3  'Fixed Dialog
   ClientHeight    =   2280
   ClientLeft      =   45
   ClientTop       =   45
   ClientWidth     =   4680
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   152
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   312
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   315
      Left            =   1875
      TabIndex        =   4
      Top             =   1905
      Width           =   915
   End
   Begin VB.Label lblDetails 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Label1"
      Height          =   285
      Left            =   495
      TabIndex        =   5
      Top             =   1500
      Width           =   3765
   End
   Begin VB.Label lblFileName 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Label2"
      Height          =   420
      Left            =   195
      TabIndex        =   3
      Top             =   495
      UseMnemonic     =   0   'False
      Width           =   4290
      WordWrap        =   -1  'True
   End
   Begin VB.Label lblLegend 
      Caption         =   "Extracting"
      Height          =   210
      Left            =   1980
      TabIndex        =   2
      Top             =   120
      Width           =   780
   End
   Begin VB.Label lblCell 
      BackColor       =   &H0000FF00&
      Height          =   180
      Index           =   0
      Left            =   525
      TabIndex        =   1
      Top             =   1245
      Width           =   135
   End
   Begin VB.Label lblProgBar 
      Alignment       =   2  'Center
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   495
      TabIndex        =   0
      Top             =   1215
      Width           =   3735
   End
End
Attribute VB_Name = "frmStreamCopyProgress"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'This form is a fun little experiment in implementing special effects
'without common controls or APIs. Just for giggles.
'A ProgressBar is implemented using a few labels and a bit of fiddling.
Private Type RGBQUAD
    rgbBlue As Byte
    rgbGreen As Byte
    rgbRed As Byte
    rgbReserved As Byte
End Type
Private m_lngCellCount As Long
Private m_StartColor As OLE_COLOR
Private m_MidColor As OLE_COLOR
Private m_EndColor As OLE_COLOR
Private m_Palette() As RGBQUAD

Private m_bCanceled As Boolean
Private WithEvents oBFC As cStreamCopy
Attribute oBFC.VB_VarHelpID = -1

Private Sub BuildPalette()
'We construct the palette to use for the progress gradient.
'This could have been done with some math and bitshifting logic
'instead of with CopyMemory, but this way is a little quicker.

    Dim rStep As Single, gStep As Single, bStep As Single
    Dim I As Integer, r As Integer, g As Integer, b As Integer
    Dim iMid As Integer
    
On Error GoTo ErrHandler
    If m_lngCellCount > 0 Then
        ReDim m_Palette(0 To m_lngCellCount)
        'Fill start and end slots with the selected colors
        CopyMemory m_Palette(0).rgbBlue, m_StartColor, 4
        CopyMemory m_Palette(m_lngCellCount - 1).rgbBlue, m_EndColor, 4
        'Find midpoint and assign mid-range color
        iMid = m_lngCellCount / 2
        CopyMemory m_Palette(iMid).rgbBlue, m_MidColor, 4
        'initialize intermediate values
        r = m_Palette(0).rgbRed
        g = m_Palette(0).rgbGreen
        b = m_Palette(0).rgbBlue
        'Compute steppings for first half
        rStep = (Int(m_Palette(iMid).rgbRed) - Int(r)) / iMid
        gStep = (Int(m_Palette(iMid).rgbGreen) - Int(g)) / iMid
        bStep = (Int(m_Palette(iMid).rgbBlue) - Int(b)) / iMid
        'Fill all intermediate entries
        For I = 1 To iMid - 1
            r = r + rStep
            g = g + gStep
            b = b + bStep
            'Truncate to legal values
            If r < 0 Then r = 0
            If g < 0 Then g = 0
            If b < 0 Then b = 0
            If r > 255 Then r = 255
            If g > 255 Then g = 255
            If b > 255 Then b = 255
            m_Palette(I).rgbRed = r
            m_Palette(I).rgbGreen = g
            m_Palette(I).rgbBlue = b
        Next
        'initialize intermediate values for 2nd half
        r = m_Palette(iMid).rgbRed
        g = m_Palette(iMid).rgbGreen
        b = m_Palette(iMid).rgbBlue
        'Compute steppings for 2nd half
        rStep = (Int(m_Palette(m_lngCellCount - 1).rgbRed) - Int(r)) / (m_lngCellCount - iMid)
        gStep = (Int(m_Palette(m_lngCellCount - 1).rgbGreen) - Int(g)) / (m_lngCellCount - iMid)
        bStep = (Int(m_Palette(m_lngCellCount - 1).rgbBlue) - Int(b)) / (m_lngCellCount - iMid)
        'And fill imtermediate entries
        For I = iMid + 1 To m_lngCellCount
            r = r + rStep
            g = g + gStep
            b = b + bStep
            'Truncate to legal values
            If r < 0 Then r = 0
            If g < 0 Then g = 0
            If b < 0 Then b = 0
            If r > 255 Then r = 255
            If g > 255 Then g = 255
            If b > 255 Then b = 255
            m_Palette(I).rgbRed = r
            m_Palette(I).rgbGreen = g
            m_Palette(I).rgbBlue = b
        Next
    End If
Done:
    Exit Sub

ErrHandler:
    'This is called in response to loading a form, so we can't have
    'it fail. Exit silently.
    BugMessage FormatVBError(Err.Number, Err.Description, Err.Source)
    Resume Done

End Sub
Friend Property Let CopyObject(objBFC As cStreamCopy)
    Set oBFC = objBFC
    lblFileName.Caption = objBFC.DestinationFile
End Property

Private Sub cmdCancel_Click()
    If MsgBox("Are you sure you wish to cancel this operation?", vbYesNo, "Abort Extraction?") = vbYes Then
        m_bCanceled = True
    End If
End Sub

Private Sub Form_Activate()
    Center Me
End Sub

Private Sub Form_Initialize()
    m_lngCellCount = 40
    'Toying around with these can yield some pretty cool effects.
    'I try to choose sensible colors, though. Green being a nice
    ' "a-okay" signal color, I chose this as the end color
    m_StartColor = vbRed
    m_MidColor = vbYellow
    m_EndColor = vbGreen
    'construct the palette
    Call BuildPalette
End Sub

Private Sub Form_Load()
    ScaleMode = 3
    Dim I As Integer, lngColor As Long
    'Initially, we hide all the cells
    lblCell(0).Visible = 0
    'We instantiate as many cells as needed to fill our progressbar
    CopyMemory lngColor, m_Palette(0).rgbBlue, 4
    lblCell(0).BackColor = lngColor
    For I = 1 To m_lngCellCount - 1
        CopyMemory lngColor, m_Palette(I).rgbBlue, 4
        Load lblCell(I)
        lblCell(I).BackColor = lngColor
        lblCell(I).Visible = False
    Next I
End Sub

Private Sub Form_Resize()
    Dim lngWidth As Long, lngLeft As Long, lngHeight As Long, lngTop As Long
    Dim I As Long
    'Center stuff
    lblProgBar.Move 30, lblProgBar.Top, ScaleWidth - 60, 17
    'Now compute the size of a single cell. We account for the
    'dimensions of the cell border and some whitespace
    lngWidth = ((lblProgBar.Width - 4) - (m_lngCellCount + 1)) / m_lngCellCount
    lngHeight = lblProgBar.Height - 6 'two-pixel border and 1-pixel whitespace on each size
    lngTop = lblProgBar.Top + 3
    lngLeft = lblProgBar.Left + 3
    'That done, we reposition each cell. Never mind which are visible.
    For I = 0 To m_lngCellCount - 1
        lblCell(I).Move lngLeft, lngTop, lngWidth, lngHeight
        lblCell(I).ZOrder 0
        'and advance the left position
        lngLeft = lngLeft + lngWidth + 1
    Next I
End Sub

Private Sub oBFC_Done()
    Set oBFC = Nothing
    Unload Me
End Sub

Private Sub oBFC_ProgressChange(ByVal Min As Currency, ByVal Max As Currency, ByVal Current As Currency, Cancel As Boolean)
    Dim dblPct As Double
    dblPct = Current / Max
    lblDetails.Caption = FormatBytes(Current) & " out of " & FormatBytes(Max) & " copied."
    Call UpdateProgress(dblPct)
    'Give user a chance to cancel
    DoEvents
    'report back to the copy object
    Cancel = m_bCanceled
End Sub
Private Sub UpdateProgress(ByVal dblPercent As Double)
    'We now show as many cells as correspond to this percentage
    Dim lngCells As Long
    Dim I As Long
    lngCells = CLng(dblPercent * m_lngCellCount)
    If lngCells Then
        For I = 0 To lngCells - 1
            lblCell(I).Visible = True
            lblCell(I).ZOrder 0
        Next
    End If
End Sub

Private Sub oBFC_UserCanceled()
    Set oBFC = Nothing
    Unload Me
End Sub
