Attribute VB_Name = "modBrowse"
'Browse for folders dialog stuff.
Option Explicit

Private Declare Function CloseHandle Lib "kernel32" (ByVal _
    hObject As Long) As Long

Private Type BrowseInfo
   hWndOwner      As Long
   pIDLRoot       As Long
   pszDisplayName As Long
   lpszTitle      As Long
   ulFlags        As Long
   lpfnCallback   As Long
   lParam         As Long
   iImage         As Long
End Type

Private Declare Sub CoTaskMemFree Lib "ole32.dll" (ByVal hMem As Long)
Private Declare Function lstrcat Lib "kernel32" Alias "lstrcatA" (ByVal lpString1 As String, ByVal lpString2 As String) As Long

Private Declare Function SHBrowseForFolder Lib "shell32" (lpbi As BrowseInfo) As Long
Private Declare Function SHGetPathFromIDList Lib "shell32" (ByVal pidList As Long, ByVal lpBuffer As String) As Long
Public Declare Function FormatMessage Lib "kernel32" Alias "FormatMessageA" (ByVal dwFlags As Long, lpSource As Any, ByVal dwMessageId As Long, ByVal dwLanguageId As Long, ByVal lpBuffer As String, ByVal nSize As Long, Arguments As Long) As Long

Private Const BIF_RETURNONLYFSDIRS = 1
Private Const MAX_PATH = 260
Private Const FORMAT_MESSAGE_FROM_SYSTEM = 4096
Private Const FORMAT_MESSAGE_IGNORE_INSERTS = 512



Public Function BrowseForFolder(hWndOwner As Long, sPrompt As String) As String

Dim iNull As Integer
Dim lpIDList As Long
Dim lResult As Long
Dim sPath As String
Dim udtBI As BrowseInfo

   With udtBI
      .hWndOwner = hWndOwner
      .lpszTitle = lstrcat(sPrompt, "")
      .ulFlags = BIF_RETURNONLYFSDIRS ' Or BIF_NEWDIALOGSTYLE
   End With

   lpIDList = SHBrowseForFolder(udtBI)
   If lpIDList Then
      sPath = String$(MAX_PATH, vbNullChar)
      lResult = SHGetPathFromIDList(lpIDList, sPath)
      Call CoTaskMemFree(lpIDList)
      iNull = InStr(sPath, vbNullChar)
      If iNull Then
         sPath = Left$(sPath, iNull - 1)
      End If
   Else
        'no dice? get the error and bail out
        Err.Raise 2001, "BrowseForFolder", ApiError(Err.LastDllError)
   End If

   BrowseForFolder = sPath

End Function

Public Function BrowseCallbackProc(ByVal hWnd As Long, ByVal uMsg As Long, lParam As Long, wParam As Long) As Long

End Function
Public Function ApiError(ByVal e As Long) As String

Dim s As String, c As Long
    s = String(MAX_PATH, 0)
    c = FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM Or _
        FORMAT_MESSAGE_IGNORE_INSERTS, _
        ByVal 0&, e, 0&, s, Len(s), ByVal 0&)

    If c Then ApiError = Left$(s, c)

End Function


