Attribute VB_Name = "modUtil"
Option Explicit

Public Const MAX_PATH = 260

Public Type FILETIME
        dwLowDateTime As Long
        dwHighDateTime As Long
End Type

Public Type WIN32_FIND_DATA
        dwFileAttributes As Long
        ftCreationTime As FILETIME
        ftLastAccessTime As FILETIME
        ftLastWriteTime As FILETIME
        nFileSizeHigh As Long
        nFileSizeLow As Long
        dwReserved0 As Long
        dwReserved1 As Long
        cFileName As String * MAX_PATH
        cAlternate As String * 14
End Type
Public Const INVALID_HANDLE_VALUE = -1
Public Const ERROR_NO_MORE_FILES = 18&
Public Const ERROR_NO_NET_OR_BAD_PATH = 1203&

Public Declare Function FindFirstFile Lib "kernel32" Alias "FindFirstFileA" (ByVal lpFileName As String, lpFindFileData As WIN32_FIND_DATA) As Long
Public Declare Function FindClose Lib "kernel32" (ByVal hFindFile As Long) As Long
Public Declare Function GetDiskFreeSpaceEx Lib "kernel32" Alias "GetDiskFreeSpaceExA" (ByVal lpDirectoryName As String, lpFreeBytesAvailable As Currency, lpTotalNumberOfBytes As Currency, lpTotalNumberOfFreeBytes As Currency) As Long

Public Function FormatVBError(ByVal Number As Long, ByVal Description As String, ByVal Source As String) As String
    FormatVBError = "Error Number: " & (Number And &H7FFFFFFF) & vbCrLf & _
               "Description :" & Description & vbCrLf & _
               "Source      :" & Source & vbCrLf
End Function

Public Sub Center(F As Form)
    F.Move (Screen.Width - F.Width) / 2, (Screen.Height - F.Height) / 2
End Sub
Public Function FormatBytes(ByVal lSize As Currency) As String

Const MEGABYTE As Currency = &H100000
Const GIGABYTE  As Currency = &H40000000
Const KILOBYTE As Currency = 1024

If lSize > GIGABYTE Then
    FormatBytes = Format$((lSize / GIGABYTE), "#####.00") & " GB"
ElseIf lSize >= MEGABYTE Then
    FormatBytes = Format$((lSize / MEGABYTE), "####.00") & " MB"
ElseIf lSize >= KILOBYTE Then
    FormatBytes = Format$((lSize / KILOBYTE), "#####.00") & " KB"
Else
    FormatBytes = lSize & " Bytes"
End If
End Function
Public Function GetFreeSpace(ByVal strDisk As String) As Currency
    Dim currFreeBytes As Currency, currTotalBytes As Currency, currAvailableFreeBytes As Currency
    Dim lngRet As Long
    lngRet = GetDiskFreeSpaceEx(strDisk, currAvailableFreeBytes, currTotalBytes, currFreeBytes)
    If lngRet Then
        GetFreeSpace = currAvailableFreeBytes * 10000
    Else
        MsgBox ApiError(Err.LastDllError), vbOKOnly, vbCritical
    End If
End Function
Public Function TrimNull(ByVal strVal As String) As String
    Dim I As Long
    If Len(strVal) = 0 Then
        TrimNull = ""
        Exit Function
    End If
    I = InStr(strVal, vbNullChar)
    Select Case I
        Case 0, 1
            TrimNull = ""
        Case Else
            TrimNull = Left$(strVal, I - 1)
    End Select
End Function
Public Function FileExists(ByVal strFile As String) As Boolean
    Dim hFind As Long
    Dim WFD As WIN32_FIND_DATA
    hFind = FindFirstFile(strFile, WFD)
    If hFind = INVALID_HANDLE_VALUE Then
        FileExists = False
    Else
        FileExists = True
    End If
    FindClose hFind
        
End Function
Public Function PathExists(ByVal strPath As String) As Boolean
Dim hFind As Long
Dim lngError As Long
Dim WFD As WIN32_FIND_DATA

Err.Clear
'look for anything in the intended folder
hFind = FindFirstFile(FixPath(strPath) & "*.*", WFD)

Select Case hFind
    Case INVALID_HANDLE_VALUE
        PathExists = False
    Case Else
        'this has been observed to work even for empty folders.
        PathExists = True
End Select
FindClose hFind

End Function
Public Function FixPath(ByVal strPath As String) As String
    'Ensures that a backslash is at the end of the path
    If Right$(strPath, 1) = "\" Then
        FixPath = strPath
    Else
        FixPath = strPath & "\"
    End If
End Function
Public Function NoFile(ByVal strPath As String) As String
    'Shaves off the filename (or the last atom of the path)
    Dim I As Long
    If Len(strPath) = 0 Then Exit Function
    I = InStrRev(strPath, "\")
    If I Then
        NoFile = Left$(strPath, I - 1)
    Else
        NoFile = strPath
    End If
End Function
Public Function NoPath(ByVal strPath As String) As String
    Dim I As Long
    If Len(strPath) = 0 Then Exit Function
    I = InStrRev(strPath, "\")
    If I Then
        NoPath = Mid$(strPath, I + 1)
    Else
        NoPath = strPath
    End If
    
End Function
Public Function Extension(ByVal strPath As String) As String

    Dim I As Long
    Dim strExt As String
    
    If Len(strPath) Then
        I = InStrRev(strPath, ".")
        If I Then
            strExt = Mid$(strPath, I + 1)
            'paranoid precaution: ensure that it really is the extension,
            'and not part of the path name
            I = InStr(strExt, "\")
            If I = 0 Then
                'we're gold. Turn lowercase and return
                Extension = LCase$(strExt)
            End If
        End If
    End If
End Function

