/* Toolbar.js
   Implements a floating toolbar in IE
*/
function _$(el){
  return document.getElementById(el);
}
/*
 The setmeup function arranges the toolbar buttons on on the toolbar in a consistent manner, and repositions the toolbar so it is always visible.
*/
function SetMeUp(){
  //find our INPUT controls, and calculate the size of the
  //toolbar
  var cx = 5;
  var buttons = document.getElementsByTagName("INPUT");
  if (buttons) {
     for (var i = 0; i < buttons.length; i++) {
        cx += (buttons[i].offsetWidth + 8);
     }
  }
  _$("divToolBar").style.pixelWidth = cx ? cx : 200;
  window.onresize = FixMeUp;
  window.onscroll=FixMeUp;
  FixMeUp();
}

function FixMeUp(){
  //find our work area
  var upperLeftX = document.body.scrollLeft;
  var upperLeftY = document.body.scrollTop;
  var lowerRightX = upperLeftX + document.body.clientWidth;
  var lowerRightY = upperLeftY + document.body.clientHeight;
  var el = _$("divToolBar");
  if (el) {
    //el.style.position = "absolute";
    el.style.pixelHeight = 40;
    //el.style.pixelTop = upperLeftY + 10;
    el.style.pixelTop = lowerRightY - (el.style.posHeight + 15);
    el.style.pixelLeft = lowerRightX -(el.style.posWidth + 15);
  }

}

window.onload = SetMeUp;
