VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cBinFileCopy"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
Const MODULE = APPLICATION + ".cBinFileCopy"
'Creator: Kenneth Srling
'Created: 2007-05-12
'Class to extract a subset of a file into another file, and
'raise some nice progress events in the process.
'The public access methods should be self-explanatory.
'Upping the STD_CHUNKSIZE value might speed things up, but
'it slows down any progress monitoring.
Public Event ProgressChange(ByVal Min As Long, ByVal Max As Long, ByVal Current As Long, ByRef Cancel As Boolean)
Public Event Done()
Public Event UserCanceled()

Private m_strSource As String
Private m_strDest As String
Private m_lngSourceOffset As Long
Private m_lngSourceSize As Long
Private m_bCanceled As Boolean
Private m_lngChunkSize As Long
Private Const STD_CHUNKSIZE As Long = 65536

Public Property Get SourceFile() As String
    SourceFile = m_strSource
End Property
Public Property Let SourceFile(ByVal strFile As String)
    m_strSource = strFile
End Property
Public Property Get DestinationFile() As String
    DestinationFile = m_strDest
End Property
Public Property Let DestinationFile(ByVal strFile As String)
    m_strDest = strFile
End Property
Public Property Get SourceOffset() As Long
    SourceOffset = m_lngSourceOffset
End Property
Public Property Let SourceOffset(ByVal lngOffset As Long)
    m_lngSourceOffset = lngOffset
End Property
Public Property Get SourceSize() As Long
    SourceSize = m_lngSourceSize
End Property
Public Property Let SourceSize(ByVal lngSize As Long)
    m_lngSourceSize = lngSize
End Property
Public Sub DoCopy()
Dim hFileSrc As Long, hFileDst As Long
Dim lngBytesRead As Long, lngBytesLeft As Long
Dim arrBytes() As Byte
Dim blnUserAborted As Boolean

On Error GoTo ErrHandler
    m_lngChunkSize = STD_CHUNKSIZE
    hFileSrc = FreeFile
    Open m_strSource For Binary Access Read As #hFileSrc
    hFileDst = FreeFile
    Open m_strDest For Binary Access Write As #hFileDst
    'Apply a couple defaults in case of missing info
    If m_lngSourceSize = 0 Then
        'Assume to the end of the file
        m_lngSourceSize = LOF(hFileSrc) - m_lngSourceOffset
    End If
    'The m_lngSourceOffset passed in is zero-based while the VB seek
    'function is one-based. So, we add one.
    Seek #hFileSrc, m_lngSourceOffset + 1
    lngBytesLeft = m_lngSourceSize 'initialize
    ReDim arrBytes(0 To m_lngChunkSize - 1)
    Do While lngBytesLeft > 0
        If lngBytesLeft < m_lngChunkSize Then
            m_lngChunkSize = lngBytesLeft
            ReDim arrBytes(0 To m_lngChunkSize - 1)
        End If
        Get #hFileSrc, , arrBytes
        Put #hFileDst, , arrBytes
        lngBytesRead = lngBytesRead + m_lngChunkSize
        lngBytesLeft = lngBytesLeft - m_lngChunkSize
        RaiseEvent ProgressChange(0, m_lngSourceSize, lngBytesRead, blnUserAborted)
        If blnUserAborted Then
            RaiseEvent UserCanceled
            Exit Do
        End If
    Loop
    If lngBytesLeft = 0 Then 'did we finish?
        RaiseEvent Done
    Else
    End If
Done:
    On Error Resume Next
    Close #hFileDst: hFileDst = 0
    Close #hFileSrc: hFileSrc = 0
    If blnUserAborted Then 'were we interrupted?
        If lngBytesRead > 0 Then
            'prompt to kill it.
            If MsgBox("Delete incomplete destination file" & vbCrLf & m_strDest & " ?", vbYesNo) = vbYes Then
                On Error Resume Next
                Kill m_strDest
            End If
        End If
    End If
    Exit Sub

ErrHandler:
    Select Case MsgBox(Err.Number & ": " & Err.Description, vbAbortRetryIgnore, "Error extracting file")
    Case vbAbort:
        blnUserAborted = True
        Resume Done
    Case vbRetry: Resume
    Case vbIgnore: Resume Next
    End Select
End Sub

Private Sub Class_Initialize()
    m_lngChunkSize = STD_CHUNKSIZE
End Sub
