VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cManifest"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
Const MODULE = "UnZixWin.cManifest"
'cManifest class
'Created: May 10th, 2007
'Created By: Kenneth Srling
'Description: Used to parse the metadata of a ZIX file
'             or torrent file and extract
'             information about the files in the archive.
'Last Revision: May 26th, 2007
Public Enum ManifestErrorEnum
    ERR_MANIFEST_BASE_ERROR = 34500
    ERR_UNEXPECTED_CHARACTER
    ERR_UNEXPECTED_EOF
End Enum
Private m_CodePage As Long
Private m_strAnnounce As String
Private m_strComment As String
Private m_strCreator As String
Private m_strEncoding As String
Private m_strName As String
Private m_dtDateCreated As Date
Private m_dht_backup_enable As Long
Private m_dht_backup_requested As Long
Private m_strfilehash As String
Private m_sha1 As String
Private m_ed2k As String
Private m_Source As String
Private m_strCreatedBy As String
Private m_strLocale As String
Private m_strModifiedBy As String
Private m_lngPieceLength As Long
Private m_lngPieceCount As Long
Private m_lngPrivate As Long
Private m_StrTitle As String
Private m_httpseeds() As String
Private m_vUnknownData As Variant

'Container for files
Public Files As Collection
Public Properties As Collection
'temporary module-level 'current file' variable
Private m_objCurrentFile As cFileEntry
Public Property Get Announce() As String
    Announce = m_strAnnounce
End Property
Public Property Get Comment() As String
    Comment = m_strComment
End Property
Public Property Get Creator() As String
    Creator = m_strCreator
End Property
Public Property Get dateCreated() As Date
    dateCreated = m_dtDateCreated
End Property
Public Property Get Encoding() As String
    Encoding = m_strEncoding
End Property
Public Property Get IsPrivate() As Long
    IsPrivate = m_lngPrivate
End Property
Public Property Get Name() As String
    Name = m_strName
End Property
Public Property Get PieceCount() As Long
    PieceCount = m_lngPieceCount
End Property

Public Function Parse(objReader As cStreamReader) As Boolean
    'Clear and init file list
    Set Files = New Collection
    'Kick off the parsing. We know that the top level
    'begins with a dictionary, so start there.
   
    Parse = ParseDict(objReader, "Root")
End Function
Private Function ParseUnknownDict(objReader As cStreamReader) As String
Const PROCEDURE = "cManifest::ParseUnknownDict"
'Carefully parse contents of list, mindful of what  it is,
'and return an array
Dim strRet As String, strVal As String
Dim strKey As String
Dim strError As String
Dim c As String * 1
c = objReader.ReadChar

If c = "d" Then
    Do
        strKey = GetString(objReader)
        If Len(strKey) Then
            'parse unknown value and wrap it in
            'tags for this key
            strRet = strRet & "<" & strKey & ">" & _
                ParseUnknown(objReader) & _
                "</" & strKey & ">"
        Else
            Exit Do
        End If
    Loop
    ParseUnknownDict = "<d>" & strRet & "</d>"
Else
    strError = "Unexpected character: " & c & vbCrLf & _
                "encountered at postion: " & objReader.Pos - 1 & vbCrLf & _
                "(Expected: 'd'"
    Err.Raise ERR_UNEXPECTED_CHARACTER, PROCEDURE, strError

End If

End Function
Private Function ParseUnknownList(objReader As cStreamReader) As String
Const PROCEDURE = "cManifest::ParseUnknownList"
'Carefully parse contents of list, mindful of what  it is,
'and return an array
Dim strRet As String, strVal As Variant
Dim strError As String
Dim c As String * 1
c = objReader.ReadChar
If c = "l" Then
    strRet = "<l>"
    Do
        strVal = ParseUnknown(objReader)
        If Len(strVal) = 0 Then Exit Do
        strRet = strRet & strVal
        strVal = vbNullString
    Loop
    strRet = strRet & "</l>"
    ParseUnknownList = strRet
Else
    strError = "Unexpected character: " & c & vbCrLf & _
                "encountered at postion: " & objReader.Pos - 1 & vbCrLf & _
                "(Expected: 'l'"
    Err.Raise ERR_UNEXPECTED_CHARACTER, PROCEDURE, strError
End If
End Function
Private Function ParseUnknown(objReader As cStreamReader) As String
'This is called if we encounter an unknown dictionary tag. We'll have to
'tiptoe through the file. We know, in any case that it'll be one of four
'things: a list, an integer, a string, or a dictionary.
Dim c As String * 1
Dim cVal As Currency
Dim strVal As String
Dim lPos As Long
'Mark positon
objReader.Push
'pick up the first character
c = objReader.ReadChar
'and roll back.
objReader.Pop

Select Case c
    Case "0" To "9":
        'a bEncoded string
        ParseUnknown = "<string>" & GetString(objReader) & "</string>"
    Case "i"
        'a number
        ParseUnknown = "<int>" & GetInteger(objReader) & "</int>"
    Case "l":
        'a list
        ParseUnknown = ParseUnknownList(objReader)
    Case "d"
        'a dictionary
        ParseUnknown = ParseUnknownDict(objReader)
    Case "e"
        'we might find ourselves here if we try to parse
        'an empty list
        ParseUnknown = vbNullString
        Exit Function
    Case Else
        'we shouldn't get here, but maybe we will someday.
        'all we can do is raise an error
        Err.Raise ERR_UNEXPECTED_CHAR, App.EXEName & ":ParseManiFest"
End Select

End Function
Private Function GetString(objReader As cStreamReader, Optional ByVal strContext As String = "") As String
'A bencoded sting is a count:chars pair. We first extract
'the count character by character until we hit the colon,
'then allocate string space and read the string in at once.
'NOTE: We have to watch for end-of-list and end-of-dict
'markers ("e"), and return an empty string if we find them
    Dim c As String * 1
    Dim lngCount As Long
    Dim strCharCount As String
    'read charcount and skip past colon
    Do
        c = objReader.ReadChar
        Select Case c
            Case "0" To "9": strCharCount = strCharCount & c
            Case "e": GetString = "": Exit Function
            Case ":": Exit Do
            Case Else
                Err.Raise ERR_UNEXPECTED_CHARACTER, "cManifest::GetString", "An illegal digit: " & c & vbCrLf & _
                "was found in the character count of a string entry at position: " & objReader.Pos() - 1
        End Select
    Loop
    'Convert string to number
    lngCount = CLng(Val(strCharCount))
    If lngCount = 0 Then
        'this happens occatsionally, when a path
        'refers to a folder instead of a file.
        If strContext = "PathAtom" Then
            GetString = "\"
        End If
        Exit Function
    End If
    GetString = objReader.ReadCharsA(lngCount)
End Function
Private Function GetDate(objReader As cStreamReader) As Date
'A bencoded date is an integer containing the number of seconds since
'midnight, january 1st, 1970. It requires a bit of massage to turn
'into a VB Date
    Dim currDate As Long
    currDate = GetInteger(objReader)
    GetDate = DateAdd("s", currDate, "1-Jan-1970")
    
End Function
Private Function GetInteger(objReader As cStreamReader) As Currency
    Dim c As String * 1
    Dim strVal As String
    
    Do
        c = objReader.ReadChar
        Select Case c
            Case "0" To "9": strVal = strVal & c
            Case "i": 'ignore - start marker for integer
            Case "e": Exit Do 'end marker for integer
        End Select
    Loop
    GetInteger = CCur(strVal)
End Function
Private Function ParseList(objReader As cStreamReader, Optional ByVal strDictName As String = "") As Boolean
Dim c As String * 1
Dim strPath As String, strAtom As String
Dim strVal As String, strMultivals As String, lngVal As Long
'Parsing a list requires that we know what we're listing, which is where
'the strDictName passed in comes in handy. We'll select a course of action
'based on what we know about ZIX manifests and torrent files
'First, let's get past the list header
c = objReader.ReadChar
If c = "l" Then
    Select Case strDictName
        Case "announce"
            'if this is called, it will be from the case below.
            'at this level, we're to dig out list of urls
            Do
                strVal = GetString(objReader)
            Loop While Len(strVal)
            ParseList = True
        Case "announce-list"
            'we call ourselves to parse the inner list.
            'see the case above
            Do While ParseList(objReader, "announce")
            Loop
        Case "files"
            'files is a list of dictionaries
            Do While ParseDict(objReader, "file") = True
                'all the work happens in parsedict. When there are no
                'more file dictionaries to parse, we get false back.
            Loop
        Case "folders"
            'folders is a list of folder dictionaries containing lists
            'of file dictionaries. Phew!
            Do While ParseDict(objReader, "folder") = True
                '
            Loop
        Case "httpseeds"
            Do
                strVal = GetString(objReader)
                If Len(strVal) Then
                    strMultivals = strMultivals & vbCrLf & strVal
                Else
                    Exit Do
                End If
            Loop
            If Len(strMultivals) Then
                m_httpseeds = Split(strMultivals, vbCrLf)
            End If
        Case "node"
            'a node list consists of an ip address (string) and a port number (integer)
            strVal = GetString(objReader)
            lngVal = GetInteger(objReader)
            'this walks past the end marker
            strVal = GetString(objReader)
            ParseList = True
        Case "nodes"
            Do While ParseList(objReader, "node") = True
                '
            Loop
            ParseList = True
        Case "path", "path.utf-8"
            'path and path.utf-8 are lists of strings, each representing
            'a directory level. We read them  in and concatenate them
            Do
                strAtom = GetString(objReader, "PathAtom")
                If Len(strAtom) = 0 Then Exit Do
                If strAtom = "\" Then
                    'the file is a folder
                    m_objCurrentFile.FileItemType = eeFolder
                    strPath = strPath & strAtom
                Else
                    strPath = strPath & "\" & strAtom
                End If
            Loop While Len(strAtom)
            If Len(strPath) Then
                'once we've got the full path object, we assign it
                'to the file object
                m_objCurrentFile.Path = strPath
                'and we can set the filename as well. It's the last
                'valid atom of the path.
                m_objCurrentFile.Name = NoPath(strPath)
            End If
        Case "unknown"
            'we don't know what the hell we're listing.
            'We probably got called by parseunknown, so
            'we call parseunknown again
            If ParseUnknown(objReader) <> Null Then
                'a non-null value indicates success at
                'parsing through the file anyway.
                ParseList = True
            End If
        End Select
ElseIf c = "e" Then
    'We hit the end marker. Bail out and return false
    ParseList = False
End If

End Function

Private Function ParseDict(objReader As cStreamReader, Optional ByVal strDictName As String = "") As Boolean
    'A dictionary is a collection of name/value pairs.
    'Simple stuff, excepting that the value can be a list or another dictionary
    'To aid in the parsing logic, the name of the dictionary (the key, in other words) may be
    'passed in. An empty name assumes the root dictionary.
    Dim c As String * 1
    Dim strKey As String
    Dim strValue As String
    Dim vValue As Variant
    
    Dim lCount As Long
    Dim cPairs As Long
    c = objReader.ReadChar
    If c = "d" Then
        'A little prepwork is required for smooth operation
        If strDictName = "file" Then
            'this dictionary constitutes all the information of a file.
            'We instantiate a cFileEntry object to collect the info.
            Set m_objCurrentFile = New cFileEntry
            'And while we're at it, we can add it to the collection.
            Files.Add m_objCurrentFile
        End If
        If strDictName = "info" Then
            'we might be dealing with a single-file info block.
            'Have an object ready just in case, but don't add it
            'to the collection just yet
            Set m_objCurrentFile = New cFileEntry
        End If
        If strDictName = "folder" Then
            'New complication. Folder is a dictionary synonymous with
            'paths, except that a folder can have attributes and a list
            'of files of its own. Currently we have no provision for this.
        End If
        If strDictName = "unknown" Then
            'we don't know what the hell kind of dictionary this is.
            'so we step throgh it here instead. We cannot assume anything
            'about the format, only that each value begins with a key
            BugMessage "Unknown Dictionary:"
            Do
                strKey = GetString(objReader)
                If Len(strKey) Then
                    strValue = ParseUnknown(objReader)
                    BugMessage "Key: " & strKey & "; Value: " & strValue
                End If
            Loop While strKey <> ""
            ParseDict = True
            Exit Function
        End If
        Do
            'the key is always a bencoded string
            strKey = GetString(objReader)
            'Debug.Print "Key: " & strKey
            'the value can be anything; string, integer, list, dictionary...
            'It depends on the context, so we choose our weapon carefully.
            Select Case strKey
                Case ""
                    'no more keys? We hit the end of the dictionary.
                    'bail out.
                    ParseDict = True
                    Exit Do
                Case "announce"
                    m_strAnnounce = GetString(objReader)
                Case "announce-list"
                    If ParseList(objReader, "announce-list") Then
                        'do nothing
                    End If
                Case "azureus_properties"
                    If ParseDict(objReader, "azureus_properties") Then
                        'do nothing.
                    End If
                Case "codepage"
                    m_CodePage = GetInteger(objReader)
                Case "comment", "comment.utf-8", "comments"
                    m_strComment = GetString(objReader)
                Case "files"
                    If ParseList(objReader, "files") Then
                        ParseDict = True
                        'Exit Do
                    End If
                Case "created by"
                    m_strCreator = GetString(objReader)
                Case "creation date"
                    m_dtDateCreated = GetDate(objReader)
                Case "dht_backup_enable"
                    m_dht_backup_enable = GetInteger(objReader)
                Case "dht_backup_requested"
                    m_dht_backup_requested = GetInteger(objReader)
                Case "ed2k"
                    If strDictName = "info" Then
                        m_ed2k = GetString(objReader)
                    ElseIf strDictName = "file" Then
                        m_objCurrentFile.Properties.Add GetString(objReader), "ed2k"
                    End If
                Case "encoding"
                    m_strEncoding = GetString(objReader)
                Case "filehash"
                    strValue = GetString(objReader)
                    If strDictName = "file" Then
                        m_objCurrentFile.Properties.Add strValue, "filehash"
                    Else
                        m_strfilehash = strValue
                    End If
                Case "httpseeds"
                    If ParseList(objReader, "httpseeds") Then
                    End If
                Case "info"
                    'The info dictionary presents us with a bit of a quandary.
                    'For single-file mode, the "name" and "length" corresponds
                    'to a file. For mutliple files mode, "name" corresponds
                    'to a suggested target folder. The problem is, we won't
                    'know which mode it is until we parsed it, at which point
                    'it's too late.
                    'To circumvent this problem, we can take advantage of the fact
                    'that a dictionary is sorted by  definition, and that if we're
                    'dealing with a multi-file mode, we will already have processed
                    'the 'files' entry. Thus, if we have any file records when we
                    'encounter 'name', then it refers to a folder.
                    If ParseDict(objReader, "info") Then
                        'do nothing
                    End If
                Case "length"
                    vValue = GetInteger(objReader)
                    If strDictName = "file" Then
                        m_objCurrentFile.Size = vValue
                    ElseIf strDictName = "info" Then
                        If Files.Count = 0 Then
                            m_objCurrentFile.Size = vValue
                        End If
                    End If
                Case "locale"
                    m_strLocale = GetString(objReader)
                Case "md5sum"
                    strValue = GetString(objReader)
                    If strDictName = "file" Then
                        m_objCurrentFile.MD5Sum = strValue
                    End If
                    If strDictName = "info" Then
                        m_objCurrentFile.MD5Sum = strValue
                    End If
                Case "path", "path.utf-8"
                    If ParseList(objReader, strKey) Then
                    End If
                'The key 'name' has different semantics for torrent
                'and ZIX files, and also different semantics for
                'different torrents. It's either a file name or the
                'name of a (suggested) target folder.
                Case "name", "name.utf-8", "name.utf8"
                    strValue = GetString(objReader)
                    'For ZIX archives, the 'name' key of
                    'the file dictionary is the filename.
                    'For torrents, the filename is the last member
                    'of the path list. 'name' corresponds to
                    'a suggested target folder
                    If strDictName = "file" Then
                        m_objCurrentFile.Name = strValue
                    ElseIf strDictName = "info" Then
                        If Files.Count = 0 Then
                            m_objCurrentFile.Name = strValue
                        Else
                            m_strName = strValue
                        End If
                    ElseIf strDictName = "folder" Then
                        'we're in the folders list
                        m_strName = strValue
                    End If
'                Case "name.utf-8", "name.utf8"
'                    If strDictName = "file" Then
'                        m_objCurrentFile.Name = strValue
'                    ElseIf strDictName = "info" Then
'                        m_strName = strValue
'                    End If
'                    strValue = GetString(objReader)
                'These keys apply to torrent files
                Case "nodes"
                    If ParseList(objReader, "nodes") Then
                        'success
                    End If
                Case "piece length"
                    m_lngPieceLength = GetInteger(objReader)
                Case "pieces"
                    strValue = GetString(objReader)
                Case "private"
                    m_lngPrivate = GetInteger(objReader)
                Case "publisher", "publisher-url", "publisher-url.utf-8", "publisher.utf-8"
                    strValue = GetString(objReader)
                'These keys apply specifically to file entries
                'withing ZIX manifest files. The module-level
                'object variable is instantiated elsewhere, and
                'will be added to the Files collection elsewhere.
                'right now, we're just filling it with attributes.
                Case "attribute"
                    If strDictName = "file" Then
                        m_objCurrentFile.Attributes = GetInteger(objReader)
                    ElseIf strDictName = "folder" Then
                        'this is a folder. Ignore this, but we have
                        'to read past it
                        vValue = GetInteger(objReader)
                    End If
                Case "finish"
                    m_objCurrentFile.Finish = GetInteger(objReader)
                Case "folders"
                    If ParseList(objReader, "folders") Then
                        'then nothing. We're good.
                    End If
                Case "modified-by"
                    'this has been observed to be both a
                    'string or a list. Account for both.
                    m_strModifiedBy = ParseUnknown(objReader)
                Case "resume"
                    'This is risky. Paths are given as keys, and
                    'there is little chance of ensuring XML compliance
                    'as it stands. TODO: Rewrite
                    'a dictionary of file dictinaries?
                    strValue = ParseUnknown(objReader)
                Case "size"
                    If strDictName = "file" Then
                        m_objCurrentFile.Size = GetInteger(objReader)
                    Else
                        'size of a folder. We should ignore this.
                        'it'll probably be a zero anyway
                        vValue = GetInteger(objReader)
                    End If
                Case "sha1"
                    strValue = GetString(objReader)
                    If strDictName = "info" Then
                        m_sha1 = strValue
                    ElseIf strDictName = "file" Then
                        m_objCurrentFile.Properties.Add strValue, "sha1"
                    End If
                Case "start"
                    m_objCurrentFile.Start = GetInteger(objReader)
                Case "source"
                    m_Source = GetString(objReader)
                Case "title"
                    m_StrTitle = GetString(objReader)
                Case "torrent filename"
                    'emitted by some torrent creators. It doesn't matter
                    'to anybody.
                    strValue = GetString(objReader)
                Case Else
                    BugMessage "Unknown Key: " & strDictName & " / " & strKey
                    vValue = ParseUnknown(objReader)
                    BugMessage "Unknown Value: " & vValue
                    If strDictName = "file" Then
                        m_objCurrentFile.Properties.Add vValue, strKey
                    End If
                    
                    'Err.Raise ERR_UNRECOGNIZED_KEY, "ParseDict", _
                    "The key '" & strKey & "' was not recognized by the parser." & vbCrLf & _
                    "Unable to continue."
            End Select
            If objReader.EOF = True Then Exit Do
        Loop
        'we've finished parsing through the dictionary. If we had a
        'file object set up, here's where we should release the reference.
        If strDictName = "file" Then
            Set m_objCurrentFile = Nothing
        End If
        If strDictName = "info" Then
            If Files.Count = 0 Then
                Files.Add m_objCurrentFile
            End If
            Set m_objCurrentFile = Nothing
        End If
    ElseIf c = "e" Then
        'Hit the end-of-dictionaries marker. Bail out
        'and return false
        ParseDict = False
        Exit Function
    Else
        'getting something else constitutes an error in the stream
        'or an error somewhere in our logic. Throw error.
        Err.Raise ERR_PARSEERROR, "ParseDict", "Unexpected character in stream"
    End If
End Function
Private Function ParseCount(objReader As cStreamReader) As Long
    Dim c As String * 1
    Dim strVal As String
    Dim vVal As Variant
    Do Until c = ":"
        c = objReader.ReadChar
        strVal = strVal & c
    Loop
    vVal = Val(strVal)
    ParseCount = CLng(vVal)
End Function
Private Function ParseSize(objReader As cStreamReader) As Currency
    Dim c As String * 1
    Dim strSize As String
    Dim vVal As Variant
    Dim cVal As Currency
    Do Until c = "e"
        c = objReader.ReadChar
        strSize = strSize & c
    Loop
    vVal = Val(strSize)
    cVal = CCur(vVal)
    ParseSize = cVal
End Function

Private Sub Class_Initialize()
    Set Files = New Collection
    Set Properties = New Collection
End Sub
