VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cStreamCopy"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
Private Const MODULE_NAME = APPLICATION + "cStreamCopy"
Public Event ProgressChange(ByVal Min As Currency, ByVal Max As Currency, ByVal Current As Currency, ByRef Cancel As Boolean)
Public Event Message(ByVal strMessage As String, ByRef bCancel As Boolean)
Public Event Done()
Public Event UserCanceled()
Private m_strSource As String
Private m_strDest As String
Private m_currSourceOffset As Currency
Private m_currSourceSize As Currency
Private m_currDestSize As Currency
Private m_Compression As CompressionMethodEnum
Private m_Encryption As EncryptionMethodEnum
Private m_bCanceled As Boolean
Private m_bCryptKey() As Byte
Private m_lngCryptIndex As Long
Private Const STD_CHUNKSIZE As Long = 65536
Public Property Get Canceled() As Boolean
    Canceled = m_bCanceled
End Property
Public Property Let Compression(ByVal RHS As CompressionMethodEnum)
    m_Compression = RHS
End Property
Public Property Let Encryption(ByVal RHS As EncryptionMethodEnum)
    m_Encryption = RHS
End Property
Public Property Get SourceFile() As String
    SourceFile = m_strSource
End Property
Public Property Let SourceFile(ByVal strFile As String)
    m_strSource = strFile
End Property
Public Property Get DestinationFile() As String
    DestinationFile = m_strDest
End Property
Public Property Let DestinationFile(ByVal strFile As String)
    m_strDest = strFile
End Property
Public Property Let DestSize(ByVal RHS As Currency)
    m_currDestSize = RHS
End Property
Public Property Get SourceOffset() As Currency
    SourceOffset = m_currSourceOffset
End Property
Public Property Let SourceOffset(ByVal lngOffset As Currency)
    m_currSourceOffset = lngOffset
End Property
Public Property Get SourceSize() As Currency
    SourceSize = m_currSourceSize
End Property
Public Property Let SourceSize(ByVal lngSize As Currency)
    m_currSourceSize = lngSize
End Property
Public Function CopyCompressed() As Boolean
Const PROCEDURE = MODULE_NAME + "::CopyCompressed()"
Dim objSrc As IStream
Dim objsrc2 As ISequentialStream
Dim objComp As ZReadSeqStream
Dim objDest As IStream

Dim cyBytesRead As Currency, cyBytesRemaining As Currency
Dim lngChunkSize As Long
Dim arrBytes() As Byte
Dim blnUserAborted As Boolean
Dim strError As String
'Dealing with a compressed stream is different in many ways. For one thing, we'll be
'reading more data than is actually present in the input stream (since decompression
'almost always increases the size. However, we cannot count on either being true.
'Compressing already compressed data sometimes leads to bloat.

'We will be utilizing the ZReadSeqStream object, which is an ISequentialStream wrapper
'around the zlib compression/decompression library. We'll initialize it from an
'existing IStream already positioned at the compressed data in the file.
'We must then access its Read method through the ISequentialStream interface.
On Error GoTo ErrHandler
    lngChunkSize = 16384
    Set objSrc = SHCreateStreamOnFile(m_strSource, STGM_READ Or STGM_SHARE_EXCLUSIVE)
    Set objDest = SHCreateStreamOnFile(m_strDest, STGM_CREATE Or STGM_DIRECT Or STGM_WRITE Or STGM_SHARE_EXCLUSIVE)
    Set objComp = New ZReadSeqStream
    'allocate enough space for write ops
    'objDest.SetSize m_currDestSize / 10000
    'Position input
    objSrc.Seek m_currSourceOffset / 10000, STREAM_SEEK_SET
    'Initialize decompressor
    objComp.Initialize objSrc
    'And obtain its ISequentialStream Interface
    Set objsrc2 = objComp
    
    cyBytesRemaining = m_currDestSize 'initialize
    ReDim arrBytes(0 To lngChunkSize - 1)
    RaiseEvent Message("Extracting and decompressing...", blnUserAborted)
    Do While cyBytesRemaining > 0
        If cyBytesRemaining < lngChunkSize Then
            'last piece of the file will probably be
            'less. So, shrink the array
            lngChunkSize = cyBytesRemaining
            ReDim arrBytes(0 To lngChunkSize - 1)
        End If
        objsrc2.Read arrBytes(0), lngChunkSize 'suck it in...
        'Any manipulation would go here...
        If m_Encryption Then
            'call decryption mechanism
        End If
        'With the chunk of data in an intermediate buffer, we could also
        'compute and compare checksums on it.
        objDest.Write arrBytes(0), lngChunkSize  'and pump it out
        cyBytesRead = cyBytesRead + lngChunkSize
        cyBytesRemaining = cyBytesRemaining - lngChunkSize
        RaiseEvent ProgressChange(0, m_currDestSize, cyBytesRead, blnUserAborted)
        If blnUserAborted Then
            RaiseEvent UserCanceled
            Exit Do
        End If
    Loop
    If cyBytesRemaining = 0 Then 'did we finish?
        CopyCompressed = True
        RaiseEvent Done
    Else
    End If
Done:
    On Error Resume Next
    Set objSrc = Nothing
    Set objsrc2 = Nothing
    Set objDest = Nothing
    Set objDest = Nothing
    Set objComp = Nothing
    If blnUserAborted Then 'were we interrupted?
        If cyBytesRead > 0 Then
            'prompt to kill it.
            If MsgBox("Delete incomplete destination file" & vbCrLf & m_strDest & " ?", vbYesNo) = vbYes Then
                On Error Resume Next
                Err.Clear
                Kill m_strDest
                If Err.Number <> 0 Then
                    'file read-only?
                    MsgBox FormatVBError(Err.Number, Err.Description, Err.Source), vbOKOnly, "Failed to delete target file!", , PROCEDURE
                End If
            End If
        End If
    End If
    Exit Function

ErrHandler:
    Debug.Print Err.Number, Hex$(Err.Number), Err.Description
    Select Case Err.Number
    Case 0: 'unlikely
    Case -2147467259 'Method 'GetTypeInfoCount' of object 'IZReadSeqStream' failed
        'When we get the error, we already have what we need in the buffer.
        'We resume next to write it.
        Resume Next
    'insert anticipated errors here
    Case Else
        Select Case MsgBox(FormatVBError(Err.Number, Err.Description, Err.Source), vbAbortRetryIgnore, "Error extracting file")
            Case vbAbort:
                blnUserAborted = True
                CopyCompressed = False
                Resume Done
            Case vbRetry: Resume
            Case vbIgnore: Resume Next
        End Select
    End Select
End Function
Public Function Copy() As Boolean
Const PROCEDURE = MODULE_NAME + "::Copy()"
Dim objReader As cStreamReader
Dim objDest As IStream
Dim objCmp As ZReadSeqStream
Dim iSrc As olelib.IStream
Dim objStat As STATSTG
Dim cyBytesRead As Currency, cyBytesRemaining As Currency
Dim lngChunkSize As Long
Dim arrBytes() As Byte
Dim blnUserAborted As Boolean
Dim strError As String

If m_Compression <> eeCompNone Then
    Copy = CopyCompressed
    Exit Function
End If

On Error GoTo ErrHandler
    lngChunkSize = STD_CHUNKSIZE
    
    Set objReader = New cStreamReader
    objReader.CreateOnFile (m_strSource)
        
    'Apply a couple defaults in case of missing info
    If m_currSourceSize = 0 Then
        'Assume to the end of the file
        m_currSourceSize = objReader.TotalSize - m_currSourceOffset
    End If
    'Tell any listener what we're about to do
    If m_Encryption = eeEncryptXOR Then
        RaiseEvent Message("Extracting and decrypting...", blnUserAborted)
    Else
        RaiseEvent Message("Extracting...", blnUserAborted)
    End If
    Set objDest = SHCreateStreamOnFile(m_strDest, STGM_CREATE Or STGM_DIRECT Or STGM_WRITE Or STGM_SHARE_EXCLUSIVE)
    'allocate enough space for write ops
    objDest.SetSize m_currSourceSize / 10000
    
    objReader.SeekPos m_currSourceOffset, STREAM_SEEK_SET
'    Set objCmp = New ZReadSeqStream
'    objCmp.Initialize objReader.Stream
'    Set iSrc = objCmp
    cyBytesRemaining = m_currSourceSize 'initialize
    ReDim arrBytes(0 To lngChunkSize - 1)
    Do While cyBytesRemaining > 0
        If cyBytesRemaining < lngChunkSize Then
            'last piece of the file will probably be
            'less. So, shrink the array
            lngChunkSize = cyBytesRemaining
            ReDim arrBytes(0 To lngChunkSize - 1)
        End If
        If m_Encryption = eeEncryptXOR Then
            objReader.Read arrBytes(0), lngChunkSize 'suck it in...
            XOR_Decrypt arrBytes, lngChunkSize       '..decrypt it
            objDest.Write arrBytes(0), lngChunkSize  'and pump it out
        Else
            objReader.CopyToStream objDest, lngChunkSize 'faster just to pump it through
        End If
        cyBytesRead = cyBytesRead + lngChunkSize
        cyBytesRemaining = cyBytesRemaining - lngChunkSize
        RaiseEvent ProgressChange(0, m_currSourceSize, cyBytesRead, blnUserAborted)
        If blnUserAborted Then
            RaiseEvent UserCanceled
            Exit Do
        End If
    Loop
    If cyBytesRemaining = 0 Then 'did we finish?
        Copy = True
        RaiseEvent Done
    Else
    End If
Done:
    On Error Resume Next
    Set objReader = Nothing 'this releases all streams
    Set objDest = Nothing   'at which point the file can be accessed.
    'Close #hFileDst: hFileDst = 0
    'Close #hFileSrc: hFileSrc = 0
    If blnUserAborted Then 'were we interrupted?
        If cyBytesRead > 0 Then
            'prompt to kill it.
            If MsgBox("Delete incomplete destination file" & vbCrLf & m_strDest & " ?", vbYesNo) = vbYes Then
                On Error Resume Next
                Err.Clear
                Kill m_strDest
                If Err.Number <> 0 Then
                    'file read-only?
                    MsgBox FormatVBError(Err.Number, Err.Description, Err.Source), vbOKOnly, "Failed to delete target file!", , PROCEDURE
                End If
            End If
        End If
    End If
    Exit Function

ErrHandler:
    Select Case MsgBox(FormatVBError(Err.Number, Err.Description, Err.Source), vbAbortRetryIgnore, "Error extracting file")
        Case vbAbort:
            blnUserAborted = True
            Copy = False
            Resume Done
        Case vbRetry: Resume
        Case vbIgnore: Resume Next
    End Select
End Function
Private Sub XOR_Decrypt(arr() As Byte, cbSize As Long)
Dim i As Long
For i = 0 To cbSize - 1
    arr(i) = arr(i) Xor m_bCryptKey(m_lngCryptIndex)
    m_lngCryptIndex = (m_lngCryptIndex + 1) Mod 42
Next

End Sub
        
Private Sub Class_Initialize()
    m_bCryptKey = StrConv("UIERYQWORTWEHLKDNKDBISGLZNCBZCVNBADFIEYLJ" & Chr$(0), vbFromUnicode)
End Sub
