VERSION 5.00
Begin VB.Form frmMain 
   Caption         =   "UnZixWin Extractor"
   ClientHeight    =   5550
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   7755
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   370
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   517
   StartUpPosition =   3  'Windows Default
   Begin VB.ListBox lstContents 
      Height          =   3960
      Left            =   15
      TabIndex        =   1
      Top             =   285
      Width           =   7710
   End
   Begin VB.Label lblContents 
      BackColor       =   &H8000000C&
      Caption         =   "Open a ZIX archive to fill this list"
      ForeColor       =   &H8000000E&
      Height          =   255
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   7710
   End
   Begin VB.Label lblStatus 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Status"
      Height          =   255
      Left            =   0
      TabIndex        =   2
      Top             =   5265
      Width           =   7680
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileOpen 
         Caption         =   "&Open Archive..."
         Shortcut        =   ^O
      End
      Begin VB.Menu mnuFileSave 
         Caption         =   "&Save As..."
         Enabled         =   0   'False
         Shortcut        =   ^S
         Visible         =   0   'False
      End
      Begin VB.Menu zzSep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuTools 
      Caption         =   "&Tools"
      Begin VB.Menu mnuOptions 
         Caption         =   "&Options"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelpAbout 
         Caption         =   "&About UnZixWin..."
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private Enum FTEnum
    ftZix = 0
    ftTorrent = 1
    ftAVI = 2
End Enum

Const COLOR_ACUTE = &H2020CC
Const COLOR_WARNING = &HCCCCFF
Const COLOR_STANDARD = vbButtonFace

Private Type ZIXHEADER
    Signature As String * 3
    ManifestOffset As Currency
End Type

Private m_strSourcePath As String 'where Zix file(s) are
Private m_strDestPath As String   'where to extract the info
Private m_strFileName As String
Private m_blnAllowSave As Boolean
Private m_blnRemember As Boolean
Private m_lngLastFilterIndex As Long
Private WithEvents oCDLSave As cCommonDialog
Attribute oCDLSave.VB_VarHelpID = -1
Private WithEvents oCDLOpen As cCommonDialog
Attribute oCDLOpen.VB_VarHelpID = -1
Private WithEvents oBFC As cStreamCopy
Attribute oBFC.VB_VarHelpID = -1
Private m_CurFileType As FTEnum
Private m_Files As Collection
Private Function fCheckAvi(ByVal strFilename As String, objFile As cFileEntry) As Boolean
'This function checks the beginning of an AVI file for the RIFF AVI header.
'If it's not there, it's either crippled, encrypted or garbage, so we can warn the user.
    Dim objZ As ZReadSeqStream
    Dim objSeq As ISequentialStream
    Dim objStream As IStream
    Dim lngFileSize As Long
    Dim lngValue As Long
    Dim strHeader As String
    Dim bEncrypted As Boolean

    bEncrypted = (objFile.Encryption = eeEncryptXOR)
    'Open the ZIX archive as an IStream
    Set objStream = SHCreateStreamOnFile(strFilename, STGM_READ Or STGM_SHARE_EXCLUSIVE)
    'Position to start of AVI data
    objStream.Seek objFile.Start / 10000, STREAM_SEEK_SET
    'We do this differently depending on whether the file is compressed or not
    If objFile.Compression = eeCompNone Then
        'Uncompressed. Read directly
        objStream.Read lngValue, 4
        If bEncrypted Then
            lngValue = lngValue Xor XOR_KEY_0
        End If
        If lngValue = TAG_RIFF Then
            'ok so far. Skip past length and check for "AVI " tag
            objStream.Read lngValue, 4 ' Xor XOR_KEY_1
            objStream.Read lngValue, 4
            If bEncrypted Then
                lngValue = lngValue Xor XOR_KEY_2
            End If
            If lngValue = TAG_AVI Then
                fCheckAvi = True
            End If
        End If
    ElseIf objFile.Compression = eeCompZlib Then
        'we need to decompress the data in order to check it.
        Set objZ = New ZReadSeqStream   'Create ZLIB decompressor
        objZ.Initialize objStream       'Tie it to our IStream
        Set objSeq = objZ               'Aquire ISequentialStream interface
        objSeq.Read lngValue, 4         'Read RIFF header
        If lngValue = TAG_RIFF Then
            objSeq.Read lngFileSize, 4  'Read size of RIFF stream
            objSeq.Read lngValue, 4     'Read AVI header. It should be there
            If lngValue <> TAG_AVI Then
                Exit Function
            End If
            fCheckAvi = True
        End If
    End If
Done:
    Set objSeq = Nothing
    Set objZ = Nothing
    Set objStream = Nothing
End Function
Private Sub ReadOptions()
    On Error Resume Next
    m_blnAllowSave = GetSetting(App.Title, "Options", "AllowSave", False)
    If m_blnAllowSave Then
        'If the user didn't explicitly permit writing to the registry, then
        'there is little point trying to objtain the values
        m_strDestPath = GetSetting(App.Title, "Paths", "DestPath", App.Path)
        If Not PathExists(m_strDestPath) Then
            'folder or medium removed. Use defaults
            m_strDestPath = App.Path
        End If
        m_strSourcePath = GetSetting(App.Title, "Paths", "SourcePath", App.Path)
        If Not PathExists(m_strSourcePath) Then
            'folder or medium removed. Use defaults
            m_strSourcePath = App.Path
        End If
        m_blnRemember = GetSetting(App.Title, "Options", "Remember", True)
        m_lngLastFilterIndex = GetSetting(App.Title, "Options", "LastFilterIndex", 1)
    End If
    
End Sub
Private Sub SaveOptions()
    On Error Resume Next
    If m_blnAllowSave Then
        SaveSetting App.Title, "Paths", "DestPath", m_strDestPath
        SaveSetting App.Title, "Paths", "SourcePath", m_strSourcePath
        SaveSetting App.Title, "Options", "AllowSave", True
        SaveSetting App.Title, "Options", "Remember", m_blnRemember
        SaveSetting App.Title, "Options", "LastFilterIndex", m_lngLastFilterIndex
    Else
        'delete what we can. One key for the app title
        'will remain under HKCU\Software\VB and VBA Program Settings
        DeleteSetting App.Title, "Paths"
        DeleteSetting App.Title, "Options"
    End If
End Sub


Private Sub ProcessFile()
    Dim strExt As String
'first off, let's clear out any previous data
    Set m_Files = Nothing
    m_blnAllowSave = False
    lstContents.Clear
    lblContents.Caption = ""
    If m_strFileName = "" Then Exit Sub
    strExt = Extension(m_strFileName)
    Select Case strExt
        Case "zix"
            'zix archives need a bit of probing
            'to get to the file information
            m_CurFileType = ftZix
            If ProbeZix(m_strFileName) Then
                m_blnAllowSave = True
                ListContents (True)
            End If
        Case "torrent"
            m_CurFileType = ftTorrent
            If ProbeTorrent(m_strFileName) Then
                m_blnAllowSave = False
                ListContents (False)
            End If
        Case "avi"
            m_CurFileType = ftAVI
            If ProbeAVI(m_strFileName) Then
                m_blnAllowSave = True
                ListContents (True)
            End If
        Case Else
            Err.Raise ERR_WRONG_FILE_FORMAT, "UnZixWin::ProcessFile", "The file you are trying to open is not recognizable by UnZixWin."
            SetStatus COLOR_WARNING, True, "Unknown file type."
    End Select
mnuFileSave.Visible = m_blnAllowSave

End Sub
Private Sub SetupTabs()
Dim objFile As cFileEntry
Dim lngMaxLen As Long
Dim arrTabs() As Long
If m_Files Is Nothing Then Exit Sub
If m_Files.Count = 0 Then Exit Sub
'Measure the longest file name
For Each objFile In m_Files
    If Len(objFile.Name) > lngMaxLen Then
        lngMaxLen = Len(objFile.Name)
    End If
Next
ReDim arrTabs(0 To 1)
arrTabs(0) = (lngMaxLen + 3) * 4
SendMessage lstContents.hWnd, LB_SETTABSTOPS, 1, arrTabs(0)

End Sub
Private Sub ListContents(Optional ByVal blnCanExtract As Boolean)
    lstContents.Clear
    Dim objFile As cFileEntry
    Dim i As Long
    If Not (m_Files Is Nothing) Then
        If m_Files.Count Then
            Call SetupTabs
            For i = 1 To m_Files.Count
                Set objFile = m_Files(i)
                lstContents.AddItem objFile.Name & vbTab & " (" & objFile.Size & " bytes)"
                lstContents.ItemData(lstContents.NewIndex) = i
            Next
            If blnCanExtract Then
                lblContents.Caption = "Select &Contents to extract:"
            Else
                lblContents.Caption = "Thes files are not extractable."
            End If
        End If
        SetStatus COLOR_STANDARD, False, m_Files.Count & " files(s)"
    End If
End Sub
Private Sub ResizeControls()
    Dim lngTop As Long, lngLeft As Long
    Dim lngWidth As Long, lngWindowWidth As Long
    Dim lngHeight As Long, lngWindowHeight As Long
    lngWindowWidth = Me.ScaleWidth
    lngWindowHeight = Me.ScaleHeight
    'Resize and reposition the legend label
    lngTop = 0: lngHeight = Me.lblContents.Height
    lngWidth = lngWindowWidth: lngHeight = lblContents.Height
    lblContents.Move lngLeft, lngTop, lngWidth, lngHeight
    lngTop = lngWindowHeight - 20: lngLeft = 0: lngWidth = lngWindowWidth: lngHeight = 20
    'Resize and reposition status label
    lblStatus.Move lngLeft, lngTop, lngWidth, lngHeight
    'Slap lstContents into place
    lngTop = lblContents.Top + lblContents.Height
    lngHeight = (lngWindowHeight - lngTop) - lblStatus.Height
    lstContents.Move lngLeft, lngTop, lngWidth, lngHeight
End Sub
Private Function ProbeAVI(ByVal strPath As String) As Boolean
    Set m_Files = New Collection
    Dim objFile As cFileEntry
    Dim objReader As cStreamReader
    Dim lngSize1 As Long
    Dim lngSize2 As Long
    Dim cySize2 As Long
    Dim cySize3 As Currency
    Dim lngVal As Long
    
On Error GoTo ErrHandler

    Set objReader = New cStreamReader
    objReader.CreateOnFile (strPath)
    'First, check that the RIFF tag is first
    If objReader.ReadLong = TAG_RIFF Then
        'Read in byte length of (possibly) bogus movie
        lngSize1 = objReader.ReadLong
        'If there's no data after that, then this
        'file is not 3w Encrypted
        If lngSize1 + 8 = objReader.TotalSize Then
            'AVI ends where it's supposed to, so AVI file is probably OK.
            SetStatus COLOR_WARNING, True, "Nothing to do."
            MsgBox "This AVI file does not appear to be 3w Encrypted." & _
             vbCrLf & "There is nothing to do with it.", vbInformation
        Else
            'There is more data at the ass end of this file.
            'Let's snoop for known 3w signatures
            'Junp past the end of the data.
            objReader.SeekPos lngSize1, STREAM_SEEK_SET
            'get the second offset. It appears to be a quadword,
            'and it is absolute.
            cySize2 = objReader.ReadLongLong
            'The data in between are typically all zeroes. We could
            'check for that, but that would take too long.
            'So, we simply jump to that offset
            objReader.SeekPos cySize2, STREAM_SEEK_SET
            'Then we skip past 100 filler bytes. These are typically
            'all &HFF. We could check, but that's redundant
            objReader.SeekPos 100, STREAM_SEEK_CUR
            'Here's where the real movie would start.
            'Let's check for the RIFF header
            lngVal = objReader.ReadLong Xor XOR_KEY_0
            If lngVal = TAG_RIFF Then
                'Found the RIFF header
                Set objFile = New cFileEntry
                'Account for the fact we just read four bytes
                objFile.Start = objReader.Pos - 4
                objFile.Finish = objReader.TotalSize
                objFile.Size = objReader.TotalSize - objFile.Start
                'We don't really know which movie this actually is.
                'We could give it the same name as the enclosing one,
                'but that would be risky. Just tack on a prefix to the name.
                objFile.Name = "decrypted_" & NoPath(strPath)
                objFile.Encryption = eeEncryptXOR
                m_Files.Add objFile
                lngSize1 = objReader.ReadLong
                ProbeAVI = True
            End If
        End If
    Else
        'Not an AVI file
        MsgBox "This is not an AVI File." & vbCrLf & _
          "The content might be garbage."
    End If

Done:
    Set objReader = Nothing
    Exit Function
    
ErrHandler:
    Select Case Err.Number
        Case 0
        Case Else
        Select Case MsgBox(FormatVBError(Err.Number, Err.Description, Err.Source), _
           vbAbortRetryIgnore, "Error parsing AVI file")
           Case vbAbort: Resume Done
           Case vbRetry: Resume
           Case vbIgnore: Resume Next
        End Select
    End Select

    
End Function
Private Function ProbeTorrent(ByVal strPath As String) As Boolean
    Dim objReader As cStreamReader
    Dim objManifest As cManifest
    Dim strError As String
    
On Error GoTo ErrHandler
    lblStatus.Caption = "Analyzing Torrent..."
    Set objReader = New cStreamReader
    objReader.CreateOnFile (strPath)
    Set objManifest = New cManifest
    If objManifest.Parse(objReader) Then
        Set m_Files = objManifest.Files
        ProbeTorrent = True
    End If
Done:
    On Error Resume Next
    Set objReader = Nothing
    Set objManifest = Nothing
    Exit Function
    
ErrHandler:
    Select Case Err.Number
        Case ERR_PARSEERROR
            ProbeTorrent = False
            SetStatus COLOR_WARNING, True, Err.Description
            'propagate error
            Err.Raise Err.Number, Err.Source, Err.Description, Err.HelpFile, Err.HelpContext
        Case Else
            SetStatus COLOR_WARNING, True, Err.Description
            Select Case MsgBox(FormatVBError(Err.Number, Err.Description, Err.Source), vbAbortRetryIgnore, "Error Parsing Torrent")
                Case vbAbort:
                    ProbeTorrent = False
                    Resume Done
                Case vbRetry: Resume
                Case vbIgnore: Resume Next
            End Select
    End Select
        
End Function
Private Function ProbeZix(ByVal strPath As String) As Boolean
    Dim Header As ZIXHEADER
    Dim objReader As cStreamReader
    Dim objManifest As cManifest
    Dim strHeader As String
    On Error GoTo ErrHandler
    
    lblStatus.Caption = "Analyzing archive..."
    Set objReader = New cStreamReader
    objReader.CreateOnFile (strPath)
    If objReader.TotalSize = 0 Then
        Err.Raise ERR_FILE_IS_EMPTY, "::ProbeZix", "The file is empty."
    End If
    Header.Signature = objReader.ReadCharsA(3)
    
    If Header.Signature = "ZIX" Then 'We've got a Zix archive
        'Seek to the manifest and probe it
        Set objManifest = New cManifest
        Header.ManifestOffset = objReader.ReadLongLong
        objReader.SeekPos Header.ManifestOffset, STREAM_SEEK_SET
        'We just sought to the end of the payload.
        'The rest of the archive is the manifest.
        If objManifest.Parse(objReader) Then
            'Successfully parsed manifest. Now we can add the
            'contents to our list box
            Set m_Files = objManifest.Files
            ProbeZix = True
        Else
            SetStatus COLOR_WARNING, True, "Failed to parse archive."
            MsgBox "Failed to parse contents of archive."
        End If
    ElseIf Header.Signature = "WIN" Then
        'WINZIX header? version 2?
        objReader.SeekPos 0, STREAM_SEEK_SET 'rewind
        strHeader = objReader.ReadCharsA(6)
        If strHeader = "WINZIX" Then
            'Version 2 file. Pass the buck to that.
            ProbeZix = ProbeZix2(objReader)
            Exit Function
        Else
            ProbeZix = False
            SetStatus COLOR_WARNING, True, "This is not a Zix Archive. Header mismatch."
            Err.Raise ERR_WRONG_FILE_FORMAT, "ProbeZix", "This is not a ZIX archive."
        End If
        
    Else
        ProbeZix = False
        Err.Raise ERR_WRONG_FILE_FORMAT, "ProbeZix", "This is not a ZIX archive."
        'TODO: Throw error
    End If
    ProbeZix = True
    
Done:
    On Error Resume Next
    Set objReader = Nothing
    Set objManifest = Nothing
    Exit Function
    
ErrHandler:
    Select Case MsgBox(FormatVBError(Err.Number, Err.Description, Err.Source), vbAbortRetryIgnore, "Error Parsing Archive")
        Case vbAbort: Resume Done
        Case vbRetry: Resume
        Case vbIgnore: Resume Next
    End Select

End Function
Private Function ProbeZix2(objReader As cStreamReader) As Boolean
'Probes version 2.0 and above.
'When we enter the proc, the reader is positioned to just after the 'WINZIX' file header.
'To safeguard against future versions, this code uses paranoid precautions to catch errors
'before they mess up.
Dim intVersion As Long
Dim Entry As WZ2ENTRY
Dim strFilename As String
Dim strError As String
Dim objFile As cFileEntry
Dim bIgnore As Boolean
Dim f As frmInfo

On Error GoTo ErrHandler


Set m_Files = New Collection
'Switch reader into returning values in intel byte order instead
'of network bye order. We do this by telling the reader that its
'data stream contains NBO numbers. It converts them on the fly.
objReader.ByteOrder = eeMotorola
'Read archive version. It should always be a 3
'We could assert for this, but only if our logic breaks down.
intVersion = objReader.ReadWord
If intVersion <> 3 Then
'    Err.Raise ERR_UNEXPECTED_VALUE
End If
'repeat for every occurence of a file
Do
    Set objFile = New cFileEntry
    'Load file data into a struct before assigning to object
    With objFile
        .HeaderVersion = intVersion
        .ParentFileName = m_strFileName
        .Compression = objReader.ReadWord
        .SizeCompressed = objReader.ReadLongLong
        .Size = objReader.ReadLongLong
        .fnlen = objReader.ReadLongLong
        If .fnlen < 0 Or .fnlen > 1024 Then
            'Ugh! Something is fishy! Don't even bother to try
            'to read this filename, since it may be 4 gigs in length.
            .Name = "(Not Read - length is impossible)"
            Err.Raise ERR_UNEXPECTED_VALUE
        End If
        .Encryption = Asc(objReader.ReadChar)
        objReader.Read Entry.checksum(0), 16
        .MD5Sum = Entry.checksum
        .Name = objReader.ReadCharsA(.fnlen)
    End With
    objFile.Name = NoPath(objFile.Name, "/")
    objFile.Path = NoFile(objFile.Name, "/")
    'Here's where we sanity-check what we got. If anything smells fishy, we check the
    'header version. If it's new, we inform the user.
    If objFile.Compression <> 1 Or objFile.SizeCompressed <= 0 Or objFile.Size <= 0 Or _
        Entry.Encryption <> 0 Then
        If bIgnore = False Then
            Err.Raise ERR_UNEXPECTED_VALUE
        End If
    End If
    objFile.Start = objReader.Pos
    objFile.Finish = objFile.Start + objFile.SizeCompressed
    'test
    'Err.Raise ERR_UNEXPECTED_VALUE
    m_Files.Add objFile
    'skip past compressed data
    objReader.SeekPos objFile.SizeCompressed, STREAM_SEEK_CUR
Loop While objReader.EOF = False
ProbeZix2 = True

Done:
    Exit Function
    
ErrHandler:
    Select Case Err.Number
    Case 0:
    Case ERR_UNEXPECTED_VALUE:
        Set f = New frmInfo
        If f.ReportParseError(objFile) = vbIgnore Then
            bIgnore = True
            Unload f
            Set f = Nothing
            Resume Next
        End If
        Set f = Nothing
        Resume Done
    Case Else
        Select Case MsgBox(Err.Number & ": " & Err.Description, vbAbortRetryIgnore, "Error Parsing ZIX")
            Case vbAbort: Resume Done
            Case vbRetry: Resume
            Case vbIgnore: Resume Next
        End Select
    End Select

End Function

Private Sub Form_Activate()
    Center Me
End Sub

Private Sub Form_Load()
    'Obtain any saved source and destination paths for the benefit
    'of browsing
    Call ReadOptions
    'use them for module-level work
    Me.ScaleMode = 3 'set to pixels, in case we forget
    Set oCDLOpen = New cCommonDialog
    Set oCDLSave = New cCommonDialog
End Sub

Private Sub Form_Resize()
    If Me.WindowState = vbMinimized Then
        Exit Sub
    End If
    Call ResizeControls
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Call SaveOptions
End Sub
Private Sub SetStatus(ByVal Color As OLE_COLOR, ByVal Bold As Boolean, ByVal strText As String)
    With lblStatus
        .FontBold = Bold
        .BackColor = Color
        .Caption = strText
        .ToolTipText = strText
    End With
End Sub

Private Sub lstContents_Click()
    Dim objFile As cFileEntry
    Dim idx As Long
On Error GoTo ErrHandler
    mnuFileSave.Enabled = False
    SetStatus vbButtonFace, False, ""
    If Len(lstContents.Text) Then
        'there's something there.
        'If we can extract the file, we enable the menu
        idx = lstContents.ListIndex + 1
        If Not (m_Files Is Nothing) Then
            If m_Files.Count Then
                Set objFile = m_Files(idx)
                If objFile.IsExtractable Then
                    'Display warnings about common viruses and hoaxes.
                    'Yeech! I'll write something more elegant in an upcoming
                    'release. I promise!
                    If (objFile.Name = "codec.exe") Then
                        'Infected with Downloader.Agent.KNG
                        SetStatus COLOR_ACUTE, True, "WARNING: Almost certainly infected!"
                    ElseIf (objFile.Name) = "decompress_iso.exe" Then
                        SetStatus COLOR_ACUTE, True, "WARNING: Almost certainly infected!"
                    ElseIf (Extension(objFile.Name) = "exe") Then
                        SetStatus COLOR_WARNING, True, "WARNING: Might be infected. Ectract at your own risk."
                    ElseIf (objFile.Name = "Problems viewing the .AVI.html") Then
                        'Tries to lure you to install spyware
                        SetStatus COLOR_WARNING, True, "WARNING: Distrust any information in this file!"
                    ElseIf (objFile.Name = "001.JPG" And objFile.Size = 84738) Then
                        'This, too.
                        SetStatus COLOR_WARNING, True, "WARNING: Image contains misleading instructions."
                    ElseIf Extension(objFile.Name) = "avi" Then
                        'Quick check to see if the RIFF headers are in place.
                        If (fCheckAvi(m_strFileName, objFile) = False) Then
                            SetStatus COLOR_WARNING, True, "WARNING: AVI seems to be garbled or garbage. Waste of time."
                        Else
                            SetStatus COLOR_STANDARD, False, objFile.Name & " (" & FormatBytes(objFile.Size) & ")"
                        End If
                    Else
                        SetStatus vbButtonFace, False, objFile.Name & " (" & FormatBytes(objFile.Size) & ")"
                    End If
                    'We can only warn the user about any problems or risks. Prohibiting
                    'extraction isn't very user friendly. So...
                    mnuFileSave.Enabled = True
                Else
                    'What's the major problem?
                    If objFile.IsCompressed Then
                        SetStatus COLOR_WARNING, True, "The file is compressed. Cannot extract."
                    Else
                        'remaining option: the file simply isn't there.
                        SetStatus COLOR_WARNING, False, "This file is virtual. Cannot extract."
                    End If
                End If 'file could be extracted
            End If 'there were any files
        End If 'we have a file collection
    End If 'the user selected anything
Done:
    Exit Sub

ErrHandler:
    Select Case MsgBox(FormatVBError(Err.Number, Err.Description, Err.Source), vbAbortRetryIgnore, "An error has occurred!")
        Case vbAbort: Resume Done
        Case vbRetry: Resume
        Case vbIgnore: Resume Next
    End Select
    
End Sub

Private Sub mnuExit_Click()
    Unload Me
End Sub

Private Sub mnuFileOpen_Click()
Dim strError As String
On Error GoTo ErrHandler
    'Right here is a good place to reset all the stuff from previous
    'selections
    Set m_Files = Nothing
    lstContents.Clear
    SetStatus vbButtonFace, False, ""
    m_strFileName = ""
    Me.Caption = App.Title
    
    With oCDLOpen
        .InitDir = m_strSourcePath
        .DialogTitle = "Select ZIX archive or Torrent"
        .Filter = "ZIX archives (*.ZIX)|*.zix|AVI Files (3w Encoded) (*.avi)|*.avi|BitTorrent files (*.torrent)|*.torrent|All Files (*.*)|*.*"
        .FilterIndex = m_lngLastFilterIndex
        .flags = OFN_FILEMUSTEXIST Or OFN_PATHMUSTEXIST
        .CancelError = True
        .ShowOpen
        m_strFileName = .Filename
    End With
    If m_blnRemember Then
        m_strSourcePath = NoFile(m_strFileName)
        m_lngLastFilterIndex = oCDLOpen.FilterIndex
    End If
    SetStatus vbButtonFace, False, m_strFileName
    
    'Kick off the parsing
    Call ProcessFile
    Me.Caption = "[ " & NoPath(m_strFileName) & " ] - " & App.Title
Done:
    Exit Sub
    
ErrHandler:
    If Err = 20001 Then
        'cancel
        SetStatus vbButtonFace, False, "Open canceled."
        Resume Done
    Else
        strError = FormatVBError(Err.Number, Err.Description, Err.Source)
        
        Select Case MsgBox(strError, vbAbortRetryIgnore, "Error Opening File")
        Case vbAbort:
            SetStatus vbButtonFace, False, "Open Canceled."
            Resume Done
        Case vbRetry: Resume
        Case vbIgnore: Resume Next
        End Select
    End If
    
    
End Sub

Private Sub mnuFileSave_Click()
    Dim lngIndex As Long
    Dim objFile As cFileEntry
    Dim strDestFile As String
    Dim f As frmStreamCopyProgress
    
On Error GoTo ErrHandler
    'As a first order of business, we get a hold of the cFileEntry object
    'corresponding to the selected list index (adding one to account for zero base)
    If lstContents.ListIndex < 0 Then Exit Sub
    lngIndex = lstContents.ListIndex + 1
    Set objFile = m_Files(lngIndex)
    strDestFile = objFile.Name
    'Then we politely ask the useer where to put it
DoPrompt:
    With oCDLSave
        .InitDir = m_strDestPath
        .flags = OFN_OVERWRITEPROMPT Or OFN_PATHMUSTEXIST
        .DialogTitle = "Extract and save as:"
        .CancelError = True
        .Filter = "All Files (*.*)|*.*"
        .FilterIndex = 0
        .FileTitle = strDestFile 'suggest original name
        .Filename = strDestFile
        .ShowSave
    End With
    'pick up the name the user entered or accepted
    strDestFile = oCDLSave.Filename
    'If we get here, and the destination file exists, we
    'must have had an OK to overwrite it.
    If FileExists(strDestFile) Then
        'DOUBLE-CHECK! The user might have accidentally pointed to
        'the parent archive.
        If StrComp(strDestFile, m_strFileName, vbTextCompare) = 0 Then
            Err.Raise ERR_BAD_OVERWRITE
        End If
        'Kill doesn't work on hidden files ('file not found error')
        'So, pre-empt this by clearing the offending attributes.
        SetAttr strDestFile, 0&
        Kill strDestFile
    End If
    m_strDestPath = NoFile(strDestFile)
    'Check to see that we have enough space
    If GetFreeSpace(m_strDestPath) < objFile.Size Then
        Err.Raise ERR_NOT_ENOUGH_SPACE, App.Title, "There is not enough space left on the target drive."
    End If
    SetStatus vbButtonFace, False, "Extracting file... Please wait."
    'Instantiate a handy object to do the extraction and
    'raise some nice events in the process
    Set oBFC = New cStreamCopy
    With oBFC
        .SourceFile = m_strFileName
        .SourceOffset = objFile.Start
        .Compression = objFile.Compression
        .Encryption = objFile.Encryption
        If objFile.Compression = eeCompNone Then
            .SourceSize = objFile.Size
            .DestSize = objFile.Size
        Else
            .SourceSize = objFile.SizeCompressed
            .DestSize = objFile.Size
        End If
        .DestinationFile = strDestFile
    End With
    'We'll use a nifty little dialog to entertain
    'the user during this potentially lengthy process
    Set f = New frmStreamCopyProgress
    f.CopyObject = oBFC
    f.Show , Me
    Me.MousePointer = vbHourglass
    Me.Enabled = False 'kill input while copy in progress
    If oBFC.Copy = True Then
        'everything went okay.
        SetStatus COLOR_STANDARD, False, "Extraction complete!"
    Else
        If oBFC.Canceled Then
            SetStatus COLOR_WARNING, False, "Extraction aborted."
        End If
    End If
    
Done:
    On Error Resume Next
    Me.Enabled = True
    Me.MousePointer = vbNormal
    Set objFile = Nothing
    Set oBFC = Nothing
    Unload f
    Set f = Nothing
    Exit Sub
    
ErrHandler:
    If Err.Number = 20001 Then 'dialog cancel
        SetStatus COLOR_WARNING, False, "Extraction canceled."
        Resume Done
    ElseIf Err.Number = ERR_BAD_OVERWRITE Then
            MsgBox "You cannot overwrite the parent file" & vbCrLf & _
             "with the one inside it." & vbCrLf & vbCrLf & _
             "Source: " & m_strFileName & vbCrLf & _
             "Destinaiton: " & strDestFile, vbRetry Or vbAbort
             Resume DoPrompt
    Else
        Select Case MsgBox(FormatVBError(Err.Number, Err.Description, Err.Source), vbAbortRetryIgnore, "Error Saving File")
        Case vbAbort: Resume Done
        Case vbRetry:
            If Err.Number = ERR_NOT_ENOUGH_SPACE Then
                'give the user a chance to save someplace else
                Resume DoPrompt
            Else
                'whatever went wrong, we retry it
                Resume
            End If
        Case vbIgnore: Resume Next
        End Select
    End If
End Sub

Private Sub mnuHelpAbout_Click()
    frmAbout.Show vbModal, Me
End Sub

Private Sub mnuOptions_Click()
    Dim f As frmOptions
    Set f = New frmOptions
    With f
        .AllowSave = m_blnAllowSave
        .SourcePath = m_strSourcePath
        .DestPath = m_strDestPath
        .Remember = m_blnRemember
    End With
    f.Show vbModal, Me
    If f.Response = vbOK Then
        m_strSourcePath = f.SourcePath
        m_strDestPath = f.DestPath
        m_blnAllowSave = f.AllowSave
        m_blnRemember = f.Remember
    End If
    Unload f
    Set f = Nothing
End Sub

Private Sub oBFC_Done()
    SetStatus vbButtonFace, False, "Extraction Completed."
End Sub

Private Sub oBFC_UserCanceled()
    SetStatus &HCCCCFF, False, "Extraction Aborted."
End Sub

