Attribute VB_Name = "modUtil"
Option Explicit

Public Const MAX_PATH = 260

Public Type FILETIME
        dwLowDateTime As Long
        dwHighDateTime As Long
End Type

Public Type WIN32_FIND_DATA
        dwFileAttributes As Long
        ftCreationTime As FILETIME
        ftLastAccessTime As FILETIME
        ftLastWriteTime As FILETIME
        nFileSizeHigh As Long
        nFileSizeLow As Long
        dwReserved0 As Long
        dwReserved1 As Long
        cFileName As String * MAX_PATH
        cAlternate As String * 14
End Type
Public Const INVALID_HANDLE_VALUE = -1
Public Const ERROR_NO_MORE_FILES = 18&
Public Const ERROR_NO_NET_OR_BAD_PATH = 1203&

Public Declare Function FindFirstFile Lib "kernel32" Alias "FindFirstFileA" (ByVal lpFileName As String, lpFindFileData As WIN32_FIND_DATA) As Long
Public Declare Function FindClose Lib "kernel32" (ByVal hFindFile As Long) As Long
Public Declare Function GetDiskFreeSpaceEx Lib "kernel32" Alias "GetDiskFreeSpaceExA" (ByVal lpDirectoryName As String, lpFreeBytesAvailable As Currency, lpTotalNumberOfBytes As Currency, lpTotalNumberOfFreeBytes As Currency) As Long

Public Function FormatVBError(ByVal Number As Long, ByVal Description As String, ByVal Source As String) As String
    FormatVBError = "An error has occurred. Information below:" & vbCrLf & vbCrLf & _
               "Error Number: " & (Number And &H7FFFFFFF) & vbCrLf & _
               "Description :" & Description & vbCrLf & _
               "Source      :" & Source & vbCrLf & vbCrLf & _
               "You might try to [ignore] this error," & vbCrLf & _
               "but this may lead to even more obscure error messages."
               
End Function

Public Sub Center(f As Form)
    f.Move (Screen.Width - f.Width) / 2, (Screen.Height - f.Height) / 2
End Sub
Public Function FormatBytes(ByVal lSize As Currency) As String

Const MEGABYTE As Currency = &H100000
Const GIGABYTE  As Currency = &H40000000
Const KILOBYTE As Currency = 1024

If lSize > GIGABYTE Then
    FormatBytes = Format$((lSize / GIGABYTE), "#####.00") & " GB"
ElseIf lSize >= MEGABYTE Then
    FormatBytes = Format$((lSize / MEGABYTE), "####.00") & " MB"
ElseIf lSize >= KILOBYTE Then
    FormatBytes = Format$((lSize / KILOBYTE), "#####.00") & " KB"
Else
    FormatBytes = lSize & " Bytes"
End If
End Function
Public Function GetFreeSpace(ByVal strDisk As String) As Currency
    Dim currFreeBytes As Currency, currTotalBytes As Currency, currAvailableFreeBytes As Currency
    Dim lngRet As Long
    lngRet = GetDiskFreeSpaceEx(strDisk, currAvailableFreeBytes, currTotalBytes, currFreeBytes)
    If lngRet Then
        GetFreeSpace = currAvailableFreeBytes * 10000
    Else
        MsgBox ApiError(Err.LastDllError), vbOKOnly, vbCritical
    End If
End Function
Public Function TrimNull(ByVal strVal As String) As String
    Dim i As Long
    If Len(strVal) = 0 Then
        TrimNull = ""
        Exit Function
    End If
    i = InStr(strVal, vbNullChar)
    Select Case i
        Case 0, 1
            TrimNull = ""
        Case Else
            TrimNull = Left$(strVal, i - 1)
    End Select
End Function
Public Function FileExists(ByVal strFile As String) As Boolean
    Dim hFind As Long
    Dim WFD As WIN32_FIND_DATA
    hFind = FindFirstFile(strFile, WFD)
    If hFind = INVALID_HANDLE_VALUE Then
        FileExists = False
    Else
        FileExists = True
    End If
    FindClose hFind
        
End Function
Public Function PathExists(ByVal strPath As String) As Boolean
Dim hFind As Long
Dim lngError As Long
Dim WFD As WIN32_FIND_DATA

Err.Clear
'look for anything in the intended folder
hFind = FindFirstFile(FixPath(strPath) & "*.*", WFD)

Select Case hFind
    Case INVALID_HANDLE_VALUE
        PathExists = False
    Case Else
        'This has been observed to work even for empty folders.
        'The reason being, the API returns entries for the parent
        'folder ".." and the current folder "."
        PathExists = True
End Select
FindClose hFind

End Function
Public Function FixPath(ByVal strPath As String, Optional ByVal strSep As String = "\") As String
    'Ensures that a backslash is at the end of the path
    If Right$(strPath, 1) = strSep Then
        FixPath = strPath
    Else
        FixPath = strPath & strSep
    End If
End Function
Public Function NoFile(ByVal strPath As String, Optional ByVal strSep As String = "\") As String
    'Shaves off the filename (or the last atom of the path)
    Dim i As Long
    If Len(strPath) = 0 Then Exit Function
    i = InStrRev(strPath, strSep)
    Select Case i
        Case 0: NoFile = strPath
        Case 3: NoFile = Left$(strPath, i)
        Case Else: NoFile = Left$(strPath, i - 1)
    End Select
End Function
Public Function NoPath(ByVal strPath As String, Optional ByVal strSep As String = "\") As String
    Dim i As Long
    If Len(strPath) = 0 Then Exit Function
    i = InStrRev(strPath, strSep)
    If i Then
        NoPath = Mid$(strPath, i + 1)
    Else
        NoPath = strPath
    End If
End Function
Public Function Extension(ByVal strPath As String, Optional ByVal strPathSep As String = "\") As String
    Dim i As Long
    Dim strExt As String
    
    If Len(strPath) Then
        i = InStrRev(strPath, ".")
        If i Then
            strExt = Mid$(strPath, i + 1)
            'paranoid precaution: ensure that it really is the extension,
            'and not part of the path name
            i = InStr(strExt, strPathSep)
            If i = 0 Then
                'we're gold. Turn lowercase and return
                Extension = LCase$(strExt)
            End If
        End If
    End If
End Function

' Sort the items in array values() with bounds min and max.
Public Sub Quicksort(values() As String, _
              ByVal Min As Long, _
              ByVal Max As Long)

  Dim med_value As String
  Dim hi As Long
  Dim lo As Long
  Dim i As Long

  ' If the list has only 1 item, it's sorted.
  If Min >= Max Then Exit Sub

  ' Pick a dividing item randomly.
  i = Min + Int(Rnd(Max - Min + 1))
  med_value = values(i)

  ' Swap the dividing item to the front of the list.
  values(i) = values(Min)

  ' Separate the list into sublists.
  lo = Min
  hi = Max
  Do
    ' Look down from hi for a value < med_value.
    Do While values(hi) >= med_value
      hi = hi - 1
      If hi <= lo Then Exit Do
    Loop

    If hi <= lo Then
      ' The list is separated.
      values(lo) = med_value
      Exit Do
    End If

    ' Swap the lo and hi values.
    values(lo) = values(hi)

    ' Look up from lo for a value >= med_value.
    lo = lo + 1
    Do While values(lo) < med_value
      lo = lo + 1
      If lo >= hi Then Exit Do
    Loop

    If lo >= hi Then
      ' The list is separated.
      lo = hi
      values(hi) = med_value
      Exit Do
    End If

    ' Swap the lo and hi values.
    values(hi) = values(lo)
  Loop ' Loop until the list is separated.

  ' Recursively sort the sublists.
  Quicksort values, Min, lo - 1
  Quicksort values, lo + 1, Max

End Sub
Public Function ReverseInt(ByVal RHS As Integer) As Integer
    Dim bdata(0 To 1) As Byte
    CopyMemory bdata(0), RHS, 2
    ReverseInt = CInt(bdata(1)) + CInt(256) * CInt(bdata(0))
End Function
Public Function ReverseLong(ByVal RHS As Long) As Long
    Dim bdata(0 To 3) As Byte
    Dim lRes As Long
    CopyMemory bdata(0), RHS, 4
    lRes = bdata(3) + bdata(2) * 256 + bdata(1) * 256 ^ 2 + bdata(0) * 256 ^ 3
    ReverseLong = lRes
End Function

Function DumpBytes(ab() As Byte, cbBytes As Long) As String
    Dim i As Long, strRet As String
    For i = LBound(ab) To LBound(ab) + cbBytes - 1
        strRet = strRet & Right$("00" & Hex$(ab(i)), 2) & " "
    Next i
    DumpBytes = strRet
End Function
Function IsIDe() As Boolean
On Error GoTo ErrHandler
    Debug.Print 1 / 0
    Exit Function
ErrHandler:
    IsIDe = True
    Resume Next
End Function

